<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 20.08.2020
 * Time: 20:33
 */

namespace Diamond\Domain\Site\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

interface SiteCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    /**
     * @param string $url
     * @return mixed
     */
    public function setSearchByHost(string $url): SiteCriteriaInterface;

    /**
     * @return string|null
     */
    public function getSearchByHost(): ?string;

    /**
     * @param string|null $sort
     * @return mixed
     */
    public function setSortByHost(?string $sort): SiteCriteriaInterface;

    /**
     * @return string|null
     */
    public function getSortByHost(): ?string;

    /**
     * @param string $url
     * @return mixed
     */
    public function setSearchByName(string $url): SiteCriteriaInterface;

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string;
}