<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:12
 */

namespace Diamond\Domain\GuestBook;


use Core\Repository\DropDownInterface;
use Diamond\Domain\GuestBook\Contracts\GuestBookEntityInterface;
use Repo\Concrete\AbstractCollection;

class GuestBookCollection extends AbstractCollection implements DropDownInterface
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return GuestBookEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }
}