<?php


namespace Diamond\Application\Notification\SendEmail;



use Diamond\Application\Notification\Dto\Message;

/**
 * Class SendEmailCommand
 * @package Shop\Presentation\UseCases\Notification
 */
class SendEmailCommand
{
    /**
     * @var string
     */
    protected $email;

    /**
     * @var Message
     */
    protected $message;

    /**
     * SendEmailCommand constructor.
     * @param string $email
     * @param Message $message
     */
    public function __construct(string $email, Message $message)
    {
        $this->email = $email;
        $this->message = $message;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return Message
     */
    public function getMessage(): Message
    {
        return $this->message;
    }

}