<?php

namespace Diamond\Application\Notification\Dto;

/**
 * Объект сообщения
 *
 * @author Admin
 */
class Message
{

    public function __construct(protected string $subject,protected string $content,
            protected array $attachFilesLinks = [])
    {
    }

    /**
     * @return array
     */
    public function getAttachFilesLinks(): array
    {
        return $this->attachFilesLinks;
    }

    /**
     * @param array $attachFilesLinks
     * @return Message
     */
    public function setAttachFilesLinks(array $attachFilesLinks): Message
    {
        $this->attachFilesLinks = $attachFilesLinks;
        return $this;
    }

    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     * @return Message
     */
    public function setSubject(string $subject): Message
    {
        $this->subject = $subject;
        return $this;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     * @return Message
     */
    public function setContent(string $content): Message
    {
        $this->content = $content;
        return $this;
    }

}
