<?php

namespace Diamond\Modules\TopNews;

use Diamond\Repositories\ChangeLog\ChangeLogCriteria;
use Diamond\Repositories\ChangeLog\ChangeLogRepository;

/**
 * Description of TopNews
 *
 * @author Diamond Code Generator
 */
class TopNews extends \Core\ModuleController
{
    public $limit = 3;

    protected $repository;

    public function __construct(ChangeLogRepository $repository)
    {
        $this->repository = $repository;
    }


    public function process(): string
    {
        $changeLogs = $this->repository->findByCriteria(
            ChangeLogCriteria::create()->setLimit($this->limit)
        );
        $data = [];
        foreach ($changeLogs as $log) {
            $row = $log->toArray();
            $row['date'] = $log->getDate()->format('d.m.y');
            $data [] = $row;
        }

        return $this->render([
            'items' => $data
        ]);
    }
}               