<?php

namespace Diamond\Modules\TopMailing;

use Core\ModuleController;
use Diamond\Application\Mailing\MailingService;

/**
 * Description of TopMailing
 *
 * @author Diamond Code Generator
 */
class TopMailing extends ModuleController
{


    /**
     * TopMailing constructor.
     * @param MailingService $mailingService
     */
    public function __construct(protected MailingService $mailingService)
    {
    }

    public function process(): string
    {

        $mailings = $this->mailingService->getActiveMailing(3);

        $items = [];

        /**
         * @var \Diamond\Infrastructure\Models\Mailing\Mailing $item
         */
        foreach ($mailings as $item) {

            if(!$data = $item->getProgressData()){
                continue;
            }

            $items[] = [
                'id' => $item->getId(),
                'name' => $item->getMailingTemplate()->getName(),
                'progress' => $data->getProgress(),
                'subscribers' => $item->getMailingSubscriber()->getTitle(),
                'complete' => $data->getSending(),
                'views' => $data->getViews(),
                'errors' => $data->getErrors(),
                'all' => $data->getCount()
            ];
        }

        return $this->render([
            'items' => $items
        ]);
    }
}