<?php declare(strict_types=1);

namespace Diamond\Controllers;

use Core\BaseController;
use Core\Concrete\RequestAwareTrait;
use Core\Contracts\RequestAwareInterface;
use Diamond\Application\User\UserService;
use Symfony\Component\HttpFoundation\JsonResponse;

class SystemController extends BaseController implements RequestAwareInterface
{
    use RequestAwareTrait;


    public function __construct(private UserService $userService)
    {
    }

    public function helthCheck()
    {

        if (!$this->userService->isAuth()) {
            return new JsonResponse(['status' => 'timeout']);
        }

        return new JsonResponse(['status' => 'ok']);
    }
}