<?php

namespace Diamond\Config;

class NotificationsConfig extends \Core\IniConfig
{
    protected function getFileName()
    {
        return 'system.notification.ini';
    }

    protected string $systemErrors = 'N';

    protected int $systemCountErrors = 10;

    protected string $debugMode = 'N';

    protected string $freeDisk = 'N';

    protected int $sizeFreePercentDisk = 10;

    public function getSystemErrors(): string
    {
        return $this->systemErrors;
    }

    public function getDebugMode(): string
    {
        return $this->debugMode;
    }

    public function getFreeDisk(): string
    {
        return $this->freeDisk;
    }

    public function getSizeFreePercentDisk(): int
    {
        return $this->sizeFreePercentDisk;
    }

    public function getSystemCountErrors(): int
    {
        return $this->systemCountErrors;
    }


}