<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 05.09.2020
 * Time: 23:10
 */

namespace Diamond\Config;


class Content extends \Core\IniConfig
{
    protected function getFileName()
    {
        return 'system.content.ini';
    }


    /**
     * @var string
     */
    protected $sliderImagesPath = '/slider_images/';

    /**
     * книга отзывов по умолчанию
     * @var int
     */
    protected $bookSiteReview = 1;

    /**
     * @todo выпилить
     * @var int
     */
    protected $bookProductReview = 2;

    /**
     * публикация по дефолту
     * @var string
     */
    protected $siteCommentDefaultPubliched = "N";

    /**
     * @return int
     */
    public function getBookProductReview(): int
    {
        return $this->bookProductReview;
    }

    /**
     * @return string
     */
    public function getSiteCommentDefaultPubliched(): string
    {
        return $this->siteCommentDefaultPubliched;
    }


    /**
     * @return int
     */
    public function getBookSiteReview(): int
    {
        return $this->bookSiteReview;
    }


    /**
     * @return string
     */
    public function getSliderImagesPath(): string
    {
        return $this->sliderImagesPath;
    }

    /**
     * @param string $sliderImagesPath
     * @return Main
     */
    public function setSliderImagesPath(string $sliderImagesPath): Main
    {
        $this->sliderImagesPath = $sliderImagesPath;
        return $this;
    }

}