<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 14:55
 */

namespace Diamond\Repositories\Stat;


use Diamond\Domain\Stat\Contracts\StatCriteriaInterface;
use Diamond\Domain\Stat\StatCollection;
use Diamond\Infrastructure\Models\Stat\Stat;
use Diamond\Infrastructure\Models\Stat\StatQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class StatRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{

    public static function createEntity(): EntityInterface
    {
        return new Stat();
    }
    

    protected function createCollection(): CollectionInterface
    {
        return new StatCollection();
    }


    /**
     * @param PaginationInterface|StatCriteriaInterface $criteria
     * @param ModelCriteria|StatQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByUserId())
            ->filterByAdminUser($criteria->getFilterByUserId())
            ->_endif()
            ->_if($criteria->getSortByDateTime())
            ->orderByDatetime($criteria->getSortByDateTime())
            ->_endif()
            ->_if($criteria->getFilterByRequestMethod())
            ->filterByRequestMethod($criteria->getFilterByRequestMethod())
            ->_endif()
            ->_if($criteria->getFilterByRemoteAddr())
            ->filterByRemoteAddr($criteria->getFilterByRemoteAddr())
            ->_endif()
            ->_if($criteria->getSearchByRequestUri())
            ->filterByRequestUri('%' . $criteria->getSearchByRequestUri() . '%', Criteria::LIKE)
            ->_endif();

    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return StatQuery::create();
    }

}