<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 05.09.2020
 * Time: 22:26
 */

namespace Diamond\Repositories\SliderImage;

use Diamond\Domain\SliderImage\Contracts\SliderImageCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class SliderImageCriteria extends AbstractCriteria implements SliderImageCriteriaInterface
{

    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @var int|null
     */
    protected $filterBySiteId;

    protected string|null $filterByCode = null;

    public static function create()
    {
        return new self();
    }

    public function getFilterByCode(): ?string
    {
        return $this->filterByCode;
    }

    public function setFilterByCode(?string $filterByCode): SliderImageCriteriaInterface
    {
        $this->filterByCode = $filterByCode;
        return $this;
    }


    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool|null $filterByActive
     * @return SliderImageCriteria
     */
    public function setFilterByActive(?bool $filterByActive): SliderImageCriteriaInterface
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterBySiteId(): ?int
    {
        return $this->filterBySiteId;
    }

    /**
     * @param int|null $filterBySiteId
     * @return SliderImageCriteria
     */
    public function setFilterBySiteId(?int $filterBySiteId): SliderImageCriteriaInterface
    {
        $this->filterBySiteId = $filterBySiteId;
        return $this;
    }

}