<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:25
 */

namespace Diamond\Repositories\Report;

use Diamond\Domain\Report\Contracts\ReportCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class ReportCriteria extends AbstractCriteria implements ReportCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $filterByCode;

    /**
     * @return string|null
     */
    public function getFilterByCode(): ?string
    {
        return $this->filterByCode;
    }

    /**
     * @param string|null $filterByCode
     * @return ReportCriteria
     */
    public function setFilterByCode(?string $filterByCode): ReportCriteria
    {
        $this->filterByCode = $filterByCode;
        return $this;
    }

    public static function create()
    {
        return new self;
    }
}