<?php declare(strict_types=1);

namespace Diamond\Repositories\MessageRequest;

use Diamond\Domain\MessageRequest\Contracts\MessageRequestCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class MessageRequestCriteria extends AbstractCriteria implements MessageRequestCriteriaInterface
{

    protected string|null $searchByEmailTo = null;
    protected string|null $searchByEmailFrom = null;
    protected string|null $searchBySubject = null;
    protected string|null $searchByStatus = null;

    public static function create()
    {
        return new self;
    }

    public function getSearchByStatus(): ?string
    {
        return $this->searchByStatus;
    }

    public function setSearchByStatus(?string $searchByStatus): MessageRequestCriteria
    {
        $this->searchByStatus = $searchByStatus;
        return $this;
    }

    public function getSearchByEmailTo(): ?string
    {
        return $this->searchByEmailTo;
    }

    public function setSearchByEmailTo(?string $searchByEmailTo): MessageRequestCriteriaInterface
    {
        $this->searchByEmailTo = $searchByEmailTo;
        return $this;
    }

    public function getSearchByEmailFrom(): ?string
    {
        return $this->searchByEmailFrom;
    }

    public function setSearchByEmailFrom(?string $searchByEmailFrom): MessageRequestCriteriaInterface
    {
        $this->searchByEmailFrom = $searchByEmailFrom;
        return $this;
    }

    public function getSearchBySubject(): ?string
    {
        return $this->searchBySubject;
    }

    public function setSearchBySubject(?string $searchBySubject): MessageRequestCriteriaInterface
    {
        $this->searchBySubject = $searchBySubject;
        return $this;
    }

}