<?php

namespace Diamond\Infrastructure\Models\RuleAccess\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\RuleAccess\RuleAccess as ChildRuleAccess;
use Diamond\Infrastructure\Models\RuleAccess\RuleAccessQuery as ChildRuleAccessQuery;
use Diamond\Infrastructure\Models\RuleAccess\Map\RuleAccessTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_rule_access' table.
 *
 *
 *
 * @method     ChildRuleAccessQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildRuleAccessQuery orderByOprId($order = Criteria::ASC) Order by the opr_id column
 * @method     ChildRuleAccessQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildRuleAccessQuery orderByRlcCode($order = Criteria::ASC) Order by the rlc_code column
 *
 * @method     ChildRuleAccessQuery groupById() Group by the id column
 * @method     ChildRuleAccessQuery groupByOprId() Group by the opr_id column
 * @method     ChildRuleAccessQuery groupByTitle() Group by the title column
 * @method     ChildRuleAccessQuery groupByRlcCode() Group by the rlc_code column
 *
 * @method     ChildRuleAccessQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildRuleAccessQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildRuleAccessQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildRuleAccessQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildRuleAccessQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildRuleAccessQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildRuleAccess|null findOne(?ConnectionInterface $con = null) Return the first ChildRuleAccess matching the query
 * @method     ChildRuleAccess findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildRuleAccess matching the query, or a new ChildRuleAccess object populated from the query conditions when no match is found
 *
 * @method     ChildRuleAccess|null findOneById(int $id) Return the first ChildRuleAccess filtered by the id column
 * @method     ChildRuleAccess|null findOneByOprId(int $opr_id) Return the first ChildRuleAccess filtered by the opr_id column
 * @method     ChildRuleAccess|null findOneByTitle(string $title) Return the first ChildRuleAccess filtered by the title column
 * @method     ChildRuleAccess|null findOneByRlcCode(string $rlc_code) Return the first ChildRuleAccess filtered by the rlc_code column *

 * @method     ChildRuleAccess requirePk($key, ?ConnectionInterface $con = null) Return the ChildRuleAccess by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRuleAccess requireOne(?ConnectionInterface $con = null) Return the first ChildRuleAccess matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildRuleAccess requireOneById(int $id) Return the first ChildRuleAccess filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRuleAccess requireOneByOprId(int $opr_id) Return the first ChildRuleAccess filtered by the opr_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRuleAccess requireOneByTitle(string $title) Return the first ChildRuleAccess filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildRuleAccess requireOneByRlcCode(string $rlc_code) Return the first ChildRuleAccess filtered by the rlc_code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildRuleAccess[]|Collection find(?ConnectionInterface $con = null) Return ChildRuleAccess objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildRuleAccess> find(?ConnectionInterface $con = null) Return ChildRuleAccess objects based on current ModelCriteria
 * @method     ChildRuleAccess[]|Collection findById(int $id) Return ChildRuleAccess objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildRuleAccess> findById(int $id) Return ChildRuleAccess objects filtered by the id column
 * @method     ChildRuleAccess[]|Collection findByOprId(int $opr_id) Return ChildRuleAccess objects filtered by the opr_id column
 * @psalm-method Collection&\Traversable<ChildRuleAccess> findByOprId(int $opr_id) Return ChildRuleAccess objects filtered by the opr_id column
 * @method     ChildRuleAccess[]|Collection findByTitle(string $title) Return ChildRuleAccess objects filtered by the title column
 * @psalm-method Collection&\Traversable<ChildRuleAccess> findByTitle(string $title) Return ChildRuleAccess objects filtered by the title column
 * @method     ChildRuleAccess[]|Collection findByRlcCode(string $rlc_code) Return ChildRuleAccess objects filtered by the rlc_code column
 * @psalm-method Collection&\Traversable<ChildRuleAccess> findByRlcCode(string $rlc_code) Return ChildRuleAccess objects filtered by the rlc_code column
 * @method     ChildRuleAccess[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildRuleAccess> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class RuleAccessQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\RuleAccess\Base\RuleAccessQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\RuleAccess\\RuleAccess', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildRuleAccessQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildRuleAccessQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildRuleAccessQuery) {
            return $criteria;
        }
        $query = new ChildRuleAccessQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildRuleAccess|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(RuleAccessTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = RuleAccessTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildRuleAccess A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `opr_id`, `title`, `rlc_code` FROM `_rule_access` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildRuleAccess $obj */
            $obj = new ChildRuleAccess();
            $obj->hydrate($row);
            RuleAccessTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildRuleAccess|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(RuleAccessTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(RuleAccessTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(RuleAccessTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(RuleAccessTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleAccessTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the opr_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOprId(1234); // WHERE opr_id = 1234
     * $query->filterByOprId(array(12, 34)); // WHERE opr_id IN (12, 34)
     * $query->filterByOprId(array('min' => 12)); // WHERE opr_id > 12
     * </code>
     *
     * @param mixed $oprId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByOprId($oprId = null, ?string $comparison = null)
    {
        if (is_array($oprId)) {
            $useMinMax = false;
            if (isset($oprId['min'])) {
                $this->addUsingAlias(RuleAccessTableMap::COL_OPR_ID, $oprId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($oprId['max'])) {
                $this->addUsingAlias(RuleAccessTableMap::COL_OPR_ID, $oprId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleAccessTableMap::COL_OPR_ID, $oprId, $comparison);

        return $this;
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * $query->filterByTitle(['foo', 'bar']); // WHERE title IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $title The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByTitle($title = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleAccessTableMap::COL_TITLE, $title, $comparison);

        return $this;
    }

    /**
     * Filter the query on the rlc_code column
     *
     * Example usage:
     * <code>
     * $query->filterByRlcCode('fooValue');   // WHERE rlc_code = 'fooValue'
     * $query->filterByRlcCode('%fooValue%', Criteria::LIKE); // WHERE rlc_code LIKE '%fooValue%'
     * $query->filterByRlcCode(['foo', 'bar']); // WHERE rlc_code IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $rlcCode The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRlcCode($rlcCode = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($rlcCode)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(RuleAccessTableMap::COL_RLC_CODE, $rlcCode, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildRuleAccess $ruleAccess Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($ruleAccess = null)
    {
        if ($ruleAccess) {
            $this->addUsingAlias(RuleAccessTableMap::COL_ID, $ruleAccess->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _rule_access table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RuleAccessTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            RuleAccessTableMap::clearInstancePool();
            RuleAccessTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(RuleAccessTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(RuleAccessTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            RuleAccessTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            RuleAccessTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
