<?php

namespace Diamond\Infrastructure\Models\Page;

use Diamond\Domain\Page\Contracts\PageEntityInterface;
use Diamond\Domain\Site\Contracts\SiteEntityInterface;
use Diamond\Infrastructure\Models\Page\Base\PagesArchive as BasePagesArchive;

/**
 * Skeleton subclass for representing a row from the '_pages_archive' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class PagesArchive extends BasePagesArchive implements PageEntityInterface
{
    public function getSite(): SiteEntityInterface
    {
        if (!$domain = DomainQuery::create()->findOneById($this->getDomainId())) {
            throw new \RuntimeException('domain not found');
        }
        return $domain;
    }

}
