<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 09.09.2020
 * Time: 17:47
 */

namespace Diamond\Domain\MailingTemplate;


use Core\Repository\DropDownInterface;
use Diamond\Domain\MailingTemplate\Contracts\MailingTemplateEntityInterface;
use Diamond\Infrastructure\Models\MailingSubscriber\MailingSubscriber;
use Diamond\Infrastructure\Models\MailingTemplate\MailingTemplate;
use Repo\Concrete\AbstractCollection;

class MailingTemplateCollection extends AbstractCollection implements DropDownInterface
{
    protected function getEntityClass(): string
    {
        return MailingTemplateEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        /**
         * @var MailingTemplate $entity
         */
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }


}