<?php

namespace Diamond\Domain\ContentTag;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Diamond\Domain\ContentTag\Contracts\ContentTagEntityInterface;

/**
* Description of ContentTag
*
* @author Diamond Code Generator
*/
class ContentTagCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return ContentTagEntityInterface::class;
    }
    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }
        return $ar;
    }

}               