jQuery.noConflict();

jQuery(document).ready(function () {

    // ДЛЯ СПИСКОВ ТАБЛИЦЫ
    jQuery(document).find('[data-event="big-list"]').click(function () {

        jQuery(this).closest('.big-list').toggleClass('closed');
    });



    ///// ДЛЯ ФОРМ /////
    jQuery('input:checkbox, input:radio, select.uniformselect, input:file').uniform();

    ///// ДЛЯ ТАБЛИЦЫ /////
    jQuery('.dropdown .button-action').click(function () {

        let ul = jQuery(this).parent().find('ul');

        if (!jQuery(ul).hasClass('active')) {

            if (jQuery('ul.active:visible')) {
                jQuery('ul.active:visible').hide();
            }

            jQuery(ul).show();
            jQuery(ul).addClass('active');
        } else {
            jQuery(ul).hide();
            jQuery(ul).removeClass('active');
        }

        return false;
    });

    //----------------------------------
    jQuery('.diamond-table-action [name=action_global]').click(function(){
        form_action(jQuery('.diamond-table-action'));
    });

    ///// ДЛЯ ТАБЛИЧНОГО МЕНЮ
    jQuery(document).click(function (event) {

        var ulAct = jQuery('ul.active');

        if (!jQuery(event.target).is('ul.active') && ulAct.is(':visible')) {
            ulAct.hide();
            jQuery(ulAct).removeClass('active');
        }
    });




    //ДЛЯ ТАБЛИЧНОЕГО МУЛЬТИВЫБОРА и действия со строками
    jQuery('.stdtablecb .checkall').click(function () {
        var parentTable = jQuery(this).parents('table');
        var ch = parentTable.find('tbody input[type=checkbox]');
        if (jQuery(this).is(':checked')) {

            //check all rows in table
            ch.each(function () {
                jQuery(this).attr('checked', true);
                jQuery(this).parent().addClass('checked');	//used for the custom checkbox style
                jQuery(this).parents('tr').addClass('selected');
            });

            //check both table header and footer
            parentTable.find('.checkall').each(function () {
                jQuery(this).attr('checked', true);
            });

        } else {

            //uncheck all rows in table
            ch.each(function () {
                jQuery(this).attr('checked', false);
                jQuery(this).parent().removeClass('checked');	//used for the custom checkbox style
                jQuery(this).parents('tr').removeClass('selected');
            });

            //uncheck both table header and footer
            parentTable.find('.checkall').each(function () {
                jQuery(this).attr('checked', false);
            });
        }
    });


    ///// PERFORMS CHECK/UNCHECK BOX /////
    jQuery('.stdtablecb tbody input[type=checkbox]').click(function () {
        check_row(this);
    });


    jQuery.each(jQuery('.stdtablecb tbody input[type=checkbox]'), function (i, val) {
        check_row(this);
    });

});


function check_row(el) {
    if (jQuery(el).is(':checked')) {
        jQuery(el).parents('tr').addClass('selected');
    } else {
        jQuery(el).parents('tr').removeClass('selected');
    }
}

function form_action(form) {

    let ids = '';

    if (jQuery(form).find('input[name=ids]').val() > '') {
        return true;
    }

    jQuery.each(jQuery('.stdtable input:checkbox:checked'), function (i, el) {
        ids += el.value + ','
    });

    if (ids.length === 0) {
        jAlert('Не выбраны записи для выполнения действия', 'Предупреждение');
        return false;
    }

    if (jQuery(form).find('select[name=actiontype]').val() === '') {
        jAlert('Не выбрано действие для выполнения', 'Предупреждение');
        return false;
    }


    jConfirm('Подтверждаете выбранное действие?', 'Подтверждение', function (r) {
        if (r === true) {
            jQuery(form).find('input[name=ids]').val(ids);
            //alert(1);
            jQuery(form).submit();
        }
    });

    return false;
}

function action_row(id, actionName, confirmText ) {
    jQuery('#row' + id).addClass('selected');

    jConfirm(confirmText, 'Подтверждение', function (r) {

        if (r === true) {
            let form = jQuery('form[name=action-selected-rows]');
            form.find('input[name=ids]').val(id);

            let action = form.find('select[name=actiontype]');

            if(action.length > 0){
                action.val(actionName);
            }
            else{
                form.find('input[name=actiontype]').val(actionName);
            }

            form.submit();
        }

        jQuery('#row' + id).removeClass('selected');
    });
}

/**
 *
 * @param ob
 */
function filter_show(ob) {
    if (jQuery('.table-filter').is(':visible')) {
        jQuery('.table-filter').hide();
        jQuery(ob).html('Показать фильтр');
    } else {
        jQuery('.table-filter').show();
        jQuery(ob).html('Скрыть фильтр');
    }
}

/**
 *
 * @param ob
 */
function filter_submit(ob) {

    jQuery('form[name=main-table]').submit();

    // jQuery.each(jQuery('.table-filter td'), function (i, val) {
    //     if (!jQuery(val).find('form')) {
    //         jQuery(val).chi
    //     }
    // });

}



/**
 *
 * @param {type} o
 * @param {type} cty
 * @param {type} empty
 * @returns {undefined}
 */
function select_city(o, city, empty) {

    select_ajax(o, city, empty, "/_service/shop/cities?region=");
}

/**
 *
 * @param {type} o
 * @param {type} region
 * @param {type} empty
 * @returns {undefined}
 */
function select_region(o, region, empty, phonemask) {

    select_ajax(o, region, empty, "/_service/shop/regions?country=");


    if(window.masks !== undefined && masks[o.value]){
        jQuery(phonemask).mask(masks[o.value]);
        //console.log(masks[o.value]);
    }

}

/**
 *
 * @param {type} o
 * @param {type} cty_id
 * @param {type} empty
 * @param {type} url
 * @returns {undefined}
 */
function select_ajax(o, cty_id, empty, url) {

    cty_id = cty_id || 'cty_id';
    empty = empty || '0';

    jQuery.ajax({
        type: "GET",
        url: url + o.value,
        data: {
            name: cty_id,
            empty: empty
        },
        success: function (optionsData) {

            jQuery('select[name=' + cty_id + '] option').remove();
            jQuery.each(optionsData, function () {

                jQuery('select[name=' + cty_id + ']').append(
                    jQuery('<option />')
                        .text(this.value)
                        .val(this.id)
                );
            });
        }
    });
}

function selectValueInWindow(ob,control,value,called) {

    jQuery(ob).find('input[name='+control+']').val(value);
    jQuery(ob).find('input[name='+control+'_caption]').val(called.value);
    window.close()
}