<?php declare(strict_types=1);

namespace Diamond\Presentation\Modules\WidgetSettingsMenu;

use Core\Concrete\UserAuthAwareTrait;
use Core\Contracts\UserAuthAwareInterface;
use Core\ModuleController;

/**
 * Description of WidgetDashBoardInfo
 *
 * @author Diamond Code Generator
 */
class WidgetSettingsMenu extends ModuleController
{

    public string $active = 'main';

    public function process(): string
    {
        $items = [
            [
                'icon' => '<i class="demo-psi-home"></i>',
                'url' => '/diamond/settings/main',
                'label' => 'Основные'
            ],
            [
                'icon' => '<i class="demo-psi-mail"></i>',
                'url' => '/diamond/settings/email',
                'label' => 'Установки почты'
            ],
            [
                'icon' => '<i class="demo-psi-bar-chart"></i>',
                'url' => '/diamond/settings/seo',
                'label' => 'Сео'
            ],
            [
                'icon' => '<i class="demo-psi-tactic"></i>',
                'url' => '/diamond/settings/counters',
                'label' => 'Счетчики'
            ],
            [
                'url' => '/diamond/settings/content',
                'label' => 'Контент'
            ],
            [
                'url' => '/diamond/settings/mailing',
                'label' => 'Рассылка'
            ],
            [
                'url' => '/diamond/settings/other',
                'label' => 'Прочее'
            ],
            [
                'url' => '/diamond/settings/notifications',
                'label' => 'Уведомления'
            ],
        ];

        $active = $this->active;

        array_walk(
            $items, function (&$el) use ($active){
            $el['active'] = strpos($el['url'],'/'.$active)!==false;
        });

        return $this->render([
            'items' => $items,
        ]);
    }
}               