<?php

namespace Diamond\Modules\AdminFastMenu;

use Diamond\UseCases\SecurePolicy\SecurePolicy;

/**
 * Description of slider
 *
 * @author Дмитрий
 */
class AdminFastMenu extends \Core\ModuleController
{

    protected $accessService;

    /**
     * AdminFastMenu constructor.
     * @param SecurePolicy $accessService
     */
    public function __construct(SecurePolicy $accessService)
    {
        $this->accessService = $accessService;
    }

    /**
     * @return string
     * @throws \Casbin\Exceptions\CasbinException
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        $items = \Diamond\Infrastructure\Models\Menu\MenuQuery::create()
            ->filterByName('admin-top')
            ->find();


        foreach ($items as $k => $v) {
            if (false === $this->accessService->isUserAccessMenu($v->getUrl(),'read')) {
                $items->removeObject($v);
            }
        }

        return $this->render([
            'items' => $items->toArray()
        ]);
    }
}
