<?php

namespace Diamond\Modules\AdminDomains;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use Diamond\Domain\Site\Contracts\SiteEntityInterface;
use Diamond\Infrastructure\Models\Domain\Domain;
use Diamond\Repositories\Site\SiteCriteria;
use Diamond\Repositories\Site\SiteRepository;
use DiamondTable\CommandFactory;
use DiamondTable\TableFactory;

/**
 * Description of AdminDomains
 *
 * @author Diamond Code Generator
 */
class AdminDomains extends ModuleController
{


    public function __construct(private \Diamond\Config\Main $mainConfig, private SiteRepository $siteRepository,
                                private  TableFactory $tableFactory,
                                private  ControlBuilder $controlBuilder)
    {}

    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->siteRepository, SiteCriteria::create(), 'Добавить сайт');
        $table->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION);
        $table
            ->setDefaultSortColumn('id','DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование'))
            )
            ->addColumn(
                (new ColumnTable('lang', 'Язык'))
            )
            ->addColumn(
                (new ColumnTable('domain', 'Субдомен'))
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('name'), true, null, 'Например site.ru без http[s]'
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('lang'), true, null, 'ru, en и тд'
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('domain'), true, null, 'например ekb., kazan. или .* - любой домен'
            )
            ->addFilter(
                $this
                    ->controlBuilder
                    ->buildInput('search_by_name')
            );
        return $table->render();
    }

    public function formatActions(SiteEntityInterface $entity): string
    {
        $items = [];

        $items [] = anchor(
            adaptive_url([
                'fn' => 'edit',
                'id' => $entity->getId()
            ]),
            'Изменить');

        $items [] = anchor('javascript:void(0);', 'Удалить', [
            'onclick' => "action_row({$entity->getId()},'" . CommandFactory::ROWS_DELETE . "','Действительно удалить домен?')"
        ]);

        return $this->controlBuilder->buildActionMenu($items)->render();
    }
}               