<?php

namespace Diamond\Factory;


use Diamond\Application\System\SystemService;
use Diamond\Infrastructure\Models\Page\Page;

class AdminPageFactory extends AbstractPageFactory
{

    protected $systemService;

    public function __construct(SystemService $systemService)
    {
        $this->systemService = $systemService;
    }


    /**
     * @return Page
     */
    public function createPage404(): Page
    {
        return (new Page)
            ->setUrl(admin_path('/diamond/404error'))
            ->setTitle(admin_name())
            ->setTemplate('adminblank')
            ->setContent('странница не найдена')
            ->setScript('404error.twig');
    }

    /**
     * @return Page
     */
    public function createPage403(): Page
    {
        return (new Page)
            ->setTitle(admin_name())
            ->setTemplate('adminblank')
            ->setScript('403access.twig')
            ->setUrl(admin_path('/diamond/403access'))
            ->setContent('нет прав доступа к содержимому');
    }

    /**
     * @param Page $page
     * @return mixed
     */
    public function renderPage(Page $page): string
    {
        return $this->systemService->renderAdminPage($page);
    }

}