<?php

namespace Diamond\Config;

/**
 * Description of Main
 *
 * @author Dmitriy
 */
class Main extends \Core\IniConfig
{

    
    protected $colorTheme = 'default';
    
    protected $offline;
    protected $site_title;
    protected $site_name;
    protected $site_description;
    protected $title_separator;
    protected $title_direction;
    protected $email_admin;
    protected $copyright;
    protected $signature;
    protected $signature_info;
    protected $url_suffix;
    protected $site_keywords;
    protected $compress_output; //compress scripts styles
    protected $profiler;
    protected $sessionLife;
    protected $debugIps = ""; //debug mode panel for only ips       
    protected $reCaptchaKey = '';
    protected $secretKey = '';

    public function __construct()
    {
        parent::__construct();
        //настройки суффикса берем из env
        $this->url_suffix = getenv("URL_SUFFIX");
    }

    /**
     * @return string
     */
    public function getColorTheme(): string
    {
        return $this->colorTheme;
    }

    /**
     * @param string $colorTheme
     * @return Main
     */
    public function setColorTheme(string $colorTheme): Main
    {
        $this->colorTheme = $colorTheme;
        return $this;
    }



    function getSecretKey()
    {
        return $this->secretKey;
    }

    function getReCaptchaKey()
    {
        return $this->reCaptchaKey;
    }

    function getDebugIps()
    {
        return $this->debugIps;
    }

    function getSessionLife()
    {
        return $this->sessionLife;
    }

    function setUrl_suffix($url_suffix)
    {
        $this->url_suffix = $url_suffix;
        return $this;
    }

    function getSite_keywords()
    {
        return $this->site_keywords;
    }

    function getCompress_output()
    {
        return $this->compress_output;
    }

    function getProfiler()
    {
        return $this->profiler;
    }

    function getUrl_suffix()
    {
        return $this->url_suffix;
    }

    function getSignature()
    {
        return $this->signature;
    }

    function getSignature_info()
    {
        return $this->signature_info;
    }

    function getCopyright()
    {
        return $this->copyright;
    }

    function getEmail_admin()
    {
        return $this->email_admin;
    }

    protected function getFileName()
    {
        return 'system.main.ini';
    }

    function getSite_name()
    {
        return $this->site_name;
    }

    function getOffline()
    {
        return $this->offline;
    }

    function getSite_title()
    {
        return $this->site_title;
    }

    function getSite_description()
    {
        return $this->site_description;
    }

    function getTitle_separator()
    {
        return $this->title_separator;
    }

    function getTitle_direction()
    {
        return $this->title_direction;
    }

}