<?php


namespace Diamond\Config;


use Core\IniConfig;

class Mailing extends IniConfig
{

    /**
     * По сколько писем отправляь за интерацию
     * @var int
     */
    protected int $partsSend = 50;

    protected string|null $startTime = null;

    protected string|null $endTime = null;

    protected function getFileName()
    {
        return 'system.mailing.ini';
    }

    public function getStartTime(): ?string
    {
        return $this->startTime;
    }

    public function getEndTime(): ?string
    {
        return $this->endTime;
    }


    /**
     * @return int
     */
    public function getPartsSend(): int
    {
        return $this->partsSend;
    }

    
}