<?php

namespace Diamond\Repositories\UserGroup;

use Diamond\Domain\User\Contracts\UserCriteriaInterface;
use Diamond\Domain\UserGroup\Contracts\UserGroupCriteriaInterface;
use Diamond\Domain\UserGroup\Contracts\UserGroupEntityInterface;
use Diamond\Domain\UserGroup\UserGroupCollection;
use Diamond\Infrastructure\Models\UserGroup\UserGroup;
use Diamond\Infrastructure\Models\UserGroup\UserGroupQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class UserGroupRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    protected function createQuery(): ModelCriteria
    {
        return UserGroupQuery::create();
    }


    /**
     * @return EntityInterface|UserGroupEntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new UserGroup();
    }

    /**
     * @param PaginationInterface|UserGroupCriteria $criteria
     * @param UserGroupQuery|UserGroupCriteriaInterface $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

        $dbCriteria
            ->_if($criteria->getFilterByCode() !== null)
            ->filterByGrpCode($criteria->getFilterByCode())
            ->_endif()
            ->_if($criteria->getFilterByName() !== null)
            ->filterByName($criteria->getFilterByName())
            ->_endif()
            ->_if($criteria->getSearchByName() !== null)
            ->filterByName('%' . $criteria->getSearchByName() . '%', Criteria::LIKE)
            ->_endif();

    }


    protected function createCollection(): CollectionInterface
    {
        return new UserGroupCollection();
    }
}