<?php

namespace Diamond\Repositories\Template;


use Diamond\Domain\Template\TemplateCollection;
use Diamond\Domain\Template\Contracts\TemplateCriteriaInterface;
use Diamond\Infrastructure\Models\Template\Template;
use Diamond\Infrastructure\Models\Template\TemplateQuery;
use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;

class TemplateRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{

    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new Template();
    }


    protected function createCollection(): CollectionInterface
    {
        return new TemplateCollection();
    }

    /**
     * @param PaginationInterface|TemplateCriteriaInterface $criteria
     * @param ModelCriteria|TemplateQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {

    }

    protected function createQuery(): ModelCriteria
    {
        return TemplateQuery::create();
    }

}