<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 30.08.2020
 * Time: 22:47
 */

namespace Diamond\Repositories\Page;


use Diamond\Domain\Page\Contracts\PageEntityInterface;
use Diamond\Infrastructure\Models\Page\Page;
use Diamond\Infrastructure\Models\Page\PagesArchive;
use Diamond\Infrastructure\Models\Page\PagesArchiveQuery;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\EntityInterface;

class PageArchiveRepository extends PageRepository
{
    public static function createEntity(): EntityInterface
    {
        return new PagesArchive();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return PagesArchiveQuery::create();
    }

    /**
     * @param PageEntityInterface|PagesArchive $entity
     */
    public function restore(PageEntityInterface $entity){
        $newPage = new Page();
        $newPage->populateFromArchive($entity);
        $newPage->save();
        $entity->delete();
    }
}