<?php

namespace Diamond\Repositories\Content;


use Diamond\Domain\Content\Contracts\ContentCriteriaInterface;
use Repo\Concrete\AbstractCriteria;

class ContentCriteria extends AbstractCriteria implements ContentCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $filterByDateCreate;

    /**
     * @var string|null
     */
    protected $searchByTitle;

    /**
     * @var int|null
     */
    protected $filterByCategoryId;

    /**
     * @var array|null
     */
    protected $filterByTagIds;

    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @var string|null
     */
    protected $filterByCategoryCode;

    /**
     * @var string|null
     */
    protected $sortByDateCreate;

    /**
     * @var string|null
     */
    protected $sortByDate;

    /**
     * @return string|null
     */
    public function getSortByDate(): ?string
    {
        return $this->sortByDate;
    }

    /**
     * @param string|null $sortByDate
     * @return ContentCriteria
     */
    public function setSortByDate(?string $sortByDate): ContentCriteria
    {
        $this->sortByDate = $sortByDate;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByTagIds(): ?array
    {
        return $this->filterByTagIds;
    }

    /**
     * @param array|null $filterByTagIds
     * @return ContentCriteria
     */
    public function setFilterByTagIds(?array $filterByTagIds): ContentCriteriaInterface
    {
        $this->filterByTagIds = $filterByTagIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByCategoryCode(): ?string
    {
        return $this->filterByCategoryCode;
    }

    /**
     * @param string|null $filterByCategoryCode
     * @return ContentCriteria
     */
    public function setFilterByCategoryCode(?string $filterByCategoryCode): ContentCriteria
    {
        $this->filterByCategoryCode = $filterByCategoryCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    /**
     * @param string|null $searchByTitle
     * @return ContentCriteria
     */
    public function setSearchByTitle(?string $searchByTitle): ContentCriteria
    {
        $this->searchByTitle = $searchByTitle;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByCategoryId(): ?int
    {
        return $this->filterByCategoryId;
    }

    /**
     * @param int|null $filterByCategoryId
     * @return ContentCriteria
     */
    public function setFilterByCategoryId(?int $filterByCategoryId): ContentCriteria
    {
        $this->filterByCategoryId = $filterByCategoryId;
        return $this;
    }

    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool|null $filterByActive
     * @return ContentCriteria
     */
    public function setFilterByActive(?bool $filterByActive): ContentCriteria
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getFilterByDateCreate(): ?string
    {
        return $this->filterByDateCreate;
    }

    /**
     * @param string|null $filterByDateCreate
     * @return ContentCriteria
     */
    public function setFilterByDateCreate(?string $filterByDateCreate): ContentCriteria
    {
        $this->filterByDateCreate = $filterByDateCreate;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByDateCreate(): ?string
    {
        return $this->sortByDateCreate;
    }

    /**
     * @param string|null $sortByDateCreate
     * @return ContentCriteria
     */
    public function setSortByDateCreate(?string $sortByDateCreate): ContentCriteriaInterface
    {
        $this->sortByDateCreate = $sortByDateCreate;
        return $this;
    }


    /**
     * @return ContentCriteria
     */
    public static function create()
    {
        return new self();
    }
}