<?php

namespace Diamond\Infrastructure\Models\StatBan\Map;

use Diamond\Infrastructure\Models\StatBan\StatBan;
use Diamond\Infrastructure\Models\StatBan\StatBanQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_stat_bans' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class StatBanTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.StatBan.Map.StatBanTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_stat_bans';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\StatBan\\StatBan';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.StatBan.StatBan';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_stat_bans.id';

    /**
     * the column name for the ip_mask field
     */
    public const COL_IP_MASK = '_stat_bans.ip_mask';

    /**
     * the column name for the period field
     */
    public const COL_PERIOD = '_stat_bans.period';

    /**
     * the column name for the created_at field
     */
    public const COL_CREATED_AT = '_stat_bans.created_at';

    /**
     * the column name for the rule field
     */
    public const COL_RULE = '_stat_bans.rule';

    /**
     * the column name for the uri_mask field
     */
    public const COL_URI_MASK = '_stat_bans.uri_mask';

    /**
     * the column name for the agent_mask field
     */
    public const COL_AGENT_MASK = '_stat_bans.agent_mask';

    /**
     * the column name for the host_name field
     */
    public const COL_HOST_NAME = '_stat_bans.host_name';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'IpMask', 'Period', 'CreatedAt', 'Rule', 'UriMask', 'AgentMask', 'HostName', ],
        self::TYPE_CAMELNAME     => ['id', 'ipMask', 'period', 'createdAt', 'rule', 'uriMask', 'agentMask', 'hostName', ],
        self::TYPE_COLNAME       => [StatBanTableMap::COL_ID, StatBanTableMap::COL_IP_MASK, StatBanTableMap::COL_PERIOD, StatBanTableMap::COL_CREATED_AT, StatBanTableMap::COL_RULE, StatBanTableMap::COL_URI_MASK, StatBanTableMap::COL_AGENT_MASK, StatBanTableMap::COL_HOST_NAME, ],
        self::TYPE_FIELDNAME     => ['id', 'ip_mask', 'period', 'created_at', 'rule', 'uri_mask', 'agent_mask', 'host_name', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'IpMask' => 1, 'Period' => 2, 'CreatedAt' => 3, 'Rule' => 4, 'UriMask' => 5, 'AgentMask' => 6, 'HostName' => 7, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'ipMask' => 1, 'period' => 2, 'createdAt' => 3, 'rule' => 4, 'uriMask' => 5, 'agentMask' => 6, 'hostName' => 7, ],
        self::TYPE_COLNAME       => [StatBanTableMap::COL_ID => 0, StatBanTableMap::COL_IP_MASK => 1, StatBanTableMap::COL_PERIOD => 2, StatBanTableMap::COL_CREATED_AT => 3, StatBanTableMap::COL_RULE => 4, StatBanTableMap::COL_URI_MASK => 5, StatBanTableMap::COL_AGENT_MASK => 6, StatBanTableMap::COL_HOST_NAME => 7, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'ip_mask' => 1, 'period' => 2, 'created_at' => 3, 'rule' => 4, 'uri_mask' => 5, 'agent_mask' => 6, 'host_name' => 7, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'StatBan.Id' => 'ID',
        'id' => 'ID',
        'statBan.id' => 'ID',
        'StatBanTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_stat_bans.id' => 'ID',
        'IpMask' => 'IP_MASK',
        'StatBan.IpMask' => 'IP_MASK',
        'ipMask' => 'IP_MASK',
        'statBan.ipMask' => 'IP_MASK',
        'StatBanTableMap::COL_IP_MASK' => 'IP_MASK',
        'COL_IP_MASK' => 'IP_MASK',
        'ip_mask' => 'IP_MASK',
        '_stat_bans.ip_mask' => 'IP_MASK',
        'Period' => 'PERIOD',
        'StatBan.Period' => 'PERIOD',
        'period' => 'PERIOD',
        'statBan.period' => 'PERIOD',
        'StatBanTableMap::COL_PERIOD' => 'PERIOD',
        'COL_PERIOD' => 'PERIOD',
        '_stat_bans.period' => 'PERIOD',
        'CreatedAt' => 'CREATED_AT',
        'StatBan.CreatedAt' => 'CREATED_AT',
        'createdAt' => 'CREATED_AT',
        'statBan.createdAt' => 'CREATED_AT',
        'StatBanTableMap::COL_CREATED_AT' => 'CREATED_AT',
        'COL_CREATED_AT' => 'CREATED_AT',
        'created_at' => 'CREATED_AT',
        '_stat_bans.created_at' => 'CREATED_AT',
        'Rule' => 'RULE',
        'StatBan.Rule' => 'RULE',
        'rule' => 'RULE',
        'statBan.rule' => 'RULE',
        'StatBanTableMap::COL_RULE' => 'RULE',
        'COL_RULE' => 'RULE',
        '_stat_bans.rule' => 'RULE',
        'UriMask' => 'URI_MASK',
        'StatBan.UriMask' => 'URI_MASK',
        'uriMask' => 'URI_MASK',
        'statBan.uriMask' => 'URI_MASK',
        'StatBanTableMap::COL_URI_MASK' => 'URI_MASK',
        'COL_URI_MASK' => 'URI_MASK',
        'uri_mask' => 'URI_MASK',
        '_stat_bans.uri_mask' => 'URI_MASK',
        'AgentMask' => 'AGENT_MASK',
        'StatBan.AgentMask' => 'AGENT_MASK',
        'agentMask' => 'AGENT_MASK',
        'statBan.agentMask' => 'AGENT_MASK',
        'StatBanTableMap::COL_AGENT_MASK' => 'AGENT_MASK',
        'COL_AGENT_MASK' => 'AGENT_MASK',
        'agent_mask' => 'AGENT_MASK',
        '_stat_bans.agent_mask' => 'AGENT_MASK',
        'HostName' => 'HOST_NAME',
        'StatBan.HostName' => 'HOST_NAME',
        'hostName' => 'HOST_NAME',
        'statBan.hostName' => 'HOST_NAME',
        'StatBanTableMap::COL_HOST_NAME' => 'HOST_NAME',
        'COL_HOST_NAME' => 'HOST_NAME',
        'host_name' => 'HOST_NAME',
        '_stat_bans.host_name' => 'HOST_NAME',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_stat_bans');
        $this->setPhpName('StatBan');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\StatBan\\StatBan');
        $this->setPackage('Diamond.Infrastructure.Models.StatBan');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('ip_mask', 'IpMask', 'VARCHAR', false, 255, null);
        $this->addColumn('period', 'Period', 'INTEGER', false, null, null);
        $this->addColumn('created_at', 'CreatedAt', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('rule', 'Rule', 'CHAR', true, null, 'DENY');
        $this->addColumn('uri_mask', 'UriMask', 'VARCHAR', true, 255, null);
        $this->addColumn('agent_mask', 'AgentMask', 'VARCHAR', false, 255, null);
        $this->addColumn('host_name', 'HostName', 'VARCHAR', true, 255, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? StatBanTableMap::CLASS_DEFAULT : StatBanTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (StatBan object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = StatBanTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = StatBanTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + StatBanTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = StatBanTableMap::OM_CLASS;
            /** @var StatBan $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            StatBanTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = StatBanTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = StatBanTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var StatBan $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                StatBanTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(StatBanTableMap::COL_ID);
            $criteria->addSelectColumn(StatBanTableMap::COL_IP_MASK);
            $criteria->addSelectColumn(StatBanTableMap::COL_PERIOD);
            $criteria->addSelectColumn(StatBanTableMap::COL_CREATED_AT);
            $criteria->addSelectColumn(StatBanTableMap::COL_RULE);
            $criteria->addSelectColumn(StatBanTableMap::COL_URI_MASK);
            $criteria->addSelectColumn(StatBanTableMap::COL_AGENT_MASK);
            $criteria->addSelectColumn(StatBanTableMap::COL_HOST_NAME);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.ip_mask');
            $criteria->addSelectColumn($alias . '.period');
            $criteria->addSelectColumn($alias . '.created_at');
            $criteria->addSelectColumn($alias . '.rule');
            $criteria->addSelectColumn($alias . '.uri_mask');
            $criteria->addSelectColumn($alias . '.agent_mask');
            $criteria->addSelectColumn($alias . '.host_name');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(StatBanTableMap::COL_ID);
            $criteria->removeSelectColumn(StatBanTableMap::COL_IP_MASK);
            $criteria->removeSelectColumn(StatBanTableMap::COL_PERIOD);
            $criteria->removeSelectColumn(StatBanTableMap::COL_CREATED_AT);
            $criteria->removeSelectColumn(StatBanTableMap::COL_RULE);
            $criteria->removeSelectColumn(StatBanTableMap::COL_URI_MASK);
            $criteria->removeSelectColumn(StatBanTableMap::COL_AGENT_MASK);
            $criteria->removeSelectColumn(StatBanTableMap::COL_HOST_NAME);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.ip_mask');
            $criteria->removeSelectColumn($alias . '.period');
            $criteria->removeSelectColumn($alias . '.created_at');
            $criteria->removeSelectColumn($alias . '.rule');
            $criteria->removeSelectColumn($alias . '.uri_mask');
            $criteria->removeSelectColumn($alias . '.agent_mask');
            $criteria->removeSelectColumn($alias . '.host_name');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(StatBanTableMap::DATABASE_NAME)->getTable(StatBanTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a StatBan or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or StatBan object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatBanTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\StatBan\StatBan) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(StatBanTableMap::DATABASE_NAME);
            $criteria->add(StatBanTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = StatBanQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            StatBanTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                StatBanTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _stat_bans table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return StatBanQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a StatBan or Criteria object.
     *
     * @param mixed $criteria Criteria or StatBan object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StatBanTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from StatBan object
        }

        if ($criteria->containsKey(StatBanTableMap::COL_ID) && $criteria->keyContainsValue(StatBanTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.StatBanTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = StatBanQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
