<?php

namespace Diamond\Infrastructure\Models\Menu;

use Diamond\Domain\Menu\Contracts\MenuEntityInterface;
use Diamond\Domain\Site\Contracts\SiteEntityInterface;
use Diamond\Infrastructure\Models\Menu\Base\Menu as BaseMenu;

/**
 * Skeleton subclass for representing a row from the '_menu' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
class Menu extends BaseMenu implements MenuEntityInterface
{
    protected $countChildrens = 0;

    /**
     * @return int
     */
    public function getCountChildrens(): int
    {
        return $this->countChildrens;
    }

    /**
     * @param int $countChildrens
     * @return Menu
     */
    public function setCountChildrens(int $countChildrens): Menu
    {
        $this->countChildrens = $countChildrens;
        return $this;
    }


    public function getSite(): SiteEntityInterface
    {
        return $this->getDomain();
    }

}
