<?php


namespace Diamond\Domain\MailingList;

use Diamond\Domain\MailingRequestRecipient\Contracts\MailingRequestRecipientEntityInterface;
use Diamond\Infrastructure\Models\MailingRequest\MailingRequest;
use Diamond\Infrastructure\Models\MailingRequestRecipient\MailingRequestRecipient;
use Propel\Runtime\Collection\Collection;

/**
 * VolueObject
 * Class ProgressData
 * @package Diamond\Domain\MailingList
 */
final class ProgressData
{

    /**
     * @var string
     */
    protected $body;

    /**
     * @var Collection
     */
    protected $emails;

    /**
     * @var string
     */
    protected $subject;

    protected $lastRequest;

    public function __construct(Collection $items, MailingRequest $request)
    {
        $this->body = $request->getBody();
        $this->subject = $request->getSubject();

        $this->emails = $items;
        $this->lastRequest = $request;
    }

    /**
     * @return MailingRequest|null
     */
    public function getLastRequest(): ?MailingRequest
    {
        return $this->lastRequest;
    }


    /**
     * @return string
     */
    public function getSubject(): string
    {
        return $this->subject;
    }

    /**
     * @return int
     */
    public function getCount(): int
    {
        return $this->emails->count();
    }

    /**
     * @return string
     */
    public function getBody(): string
    {
        return $this->body;
    }

    /**
     * @return Collection
     */
    public function getEmails(): Collection
    {
        return $this->emails;
    }

    /**
     * percent
     * @return int
     */
    public function getProgress(): int
    {
        $emails = $this->emails;
        $sending = 0;
        foreach ($emails as $email) {
            //если зафиксирована отправка
            //или статус в ошибке
            if ($email->getSendingAt() !== null ||
                $this->statusIsError($email->getStatus())
            ) {
                $sending++;
            }
        }
        $count = $emails->count();

        return round($sending / $count * 100);
    }

    public function getViews(): int
    {
        $views = 0;
        foreach ($this->emails as $email) {
            if ($email->getViewedAt() !== null) {
                $views++;
            }
        }
        return $views;
    }


    public function getSending(): int
    {
        $views = 0;
        foreach ($this->emails as $email) {
            if ($email->getSendingAt() !== null) {
                $views++;
            }
        }
        return $views;
    }

    public function getErrors(): int
    {
        $views = 0;
        foreach ($this->emails as $email) {
            if ($this->statusIsError($email->getStatus())) {
                $views++;
            }
        }
        return $views;
    }

    public function getReadyCount(): int
    {
        $views = 0;
        foreach ($this->emails as $email) {
            if (!$email->getSendingAt() && !$this->statusIsError($email->getStatus())) {
                $views++;
            }
        }
        return $views;
    }

    public function statusIsError(string $status): bool
    {
        return in_array($status,[
            MailingRequestRecipientEntityInterface::STATUS_ERROR_SEND,
            MailingRequestRecipientEntityInterface::STATUS_NO_VALID
        ]);
    }
}