<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 11:12
 */

namespace Diamond\Domain\GuestBookItem;


use Core\Repository\DropDownInterface;
use Diamond\Domain\GuestBookItem\Contracts\GuestBookItemEntityInterface;
use Repo\Concrete\AbstractCollection;
use Repo\Concrete\AbstractEntity;

class GuestBookItemCollection extends AbstractCollection implements DropDownInterface
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return GuestBookItemEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getTitle();
        }

        return $ar;
    }
}