<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 17.06.2020
 * Time: 18:04
 */

namespace Diamond\Domain\ChangeLog;

use Repo\Concrete\AbstractEntity;

class ChangeLogEntity extends AbstractEntity
{

    /**
     * @var string
     */
    protected $title;
    /**
     * @var \DateTime
     */
    protected $date;
    /**
     * @var string|null
     */
    protected $desc;

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return ChangeLogEntity
     */
    public function setTitle(string $title): ChangeLogEntity
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     * @return ChangeLogEntity
     */
    public function setDate(\DateTime $date): ChangeLogEntity
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDesc(): ?string
    {
        return $this->desc;
    }

    /**
     * @param string|null $desc
     * @return ChangeLogEntity
     */
    public function setDesc(?string $desc): ChangeLogEntity
    {
        $this->desc = $desc;
        return $this;
    }

}