<?php

namespace Diamond\Modules\UserData;

use Diamond\Application\Content\ContentService;
use Diamond\Application\System\SystemService;
use Diamond\Application\User\Exceptions\UserException;
use Diamond\Application\User\UserService;

/**
 * Description of AdminAuth
 *
 * @author Dmitriy
 */
class UserData extends \Core\ModuleController
{

    public function __construct(private UserService $authService, private ContentService $systemService)
    {
    }

    public function process(): string
    {

        $content = $this->systemService->getPromoBlockContentByCode('admin_user_menu');

        if($content){
            return $this->twig
                ->createTemplate($content, md5(microtime()))
                ->render();
        }

        try {
            $user = $this->authService->getAuthUser();
        } catch (UserException $ex) {
            return '';
        }



        $authPage = $this->systemService->getPageAuth();

        return $this->render([
            'name' => $user->getName(),
            'group' => $user->getUserGroup()->getName(),
            'email' => $user->getEmail(),
            'user_id' => $user->getId(),
            'auth_url' => $authPage->getUrl()
        ]);
    }
}
