<?php declare(strict_types=1);

namespace Diamond\Presentation\Modules\UserAdminTopMenu;

use Core\ModuleController;
use Diamond\Application\Content\ContentService;

/**
* Description of UserAdminTopMenu
*
* @author Diamond Code Generator
*/
class UserAdminTopMenu extends ModuleController
{


    public function __construct(private ContentService $systemService)
    {
    }

    public function process(): string
    {
        $content = $this->systemService->getPromoBlockContentByCode('admin_top_menu');

        if($content){
            return $this->twig
                ->createTemplate($content, md5(microtime()))
                ->render();
        }

        return $this->render();
    }
}               