<?php

namespace Diamond\Modules\AdminPromoblock;

use ActiveTable\ColumnTable;
use Diamond\Application\Content\ContentService;
use Diamond\Domain\PromoBlock\Contracts\PromoBlockEntityInterface;
use Core\Helpers\Text;
use Core\Form\ControlBuilder;
use Diamond\Modules\Promoblock\Promoblock;
use Diamond\Repositories\PromoBlock\PromoBlockCriteria;
use DiamondTable\TableFactory;

/**
 * Description of AdminPromoblock
 *
 * @author Admin
 */
class AdminPromoblock extends \Core\ModuleController
{

    public function __construct(private ContentService $contentService,
                                private TableFactory   $tableFactory,
                                private ControlBuilder $builder)
    {
    }


    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable(
            $this->contentService->getPromoBlockRepository(),
            PromoBlockCriteria::create(),
            'Добавить промоблок'
        );

        $table
            ->setDefaultSortColumn('id', 'DESC')
            ->addColumn(
                (new ColumnTable('id', '№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('code', 'Идентификатор блока'))
            )
            ->addColumn(
                (new ColumnTable('title', 'Наименование'))
            )
            ->addColumn(
                (new ColumnTable('urlMask', 'Адрес страницы'))->setFormat($this, 'formatUrl')
            )
            ->addColumn(
                (new ColumnTable('body', 'Содержание'))
                    ->setFormat($this, 'formatBody')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatAction')
            );

        $table
            ->addField(
                $this->builder->buildInput('title')
            )
            ->addField(
                $this->builder->buildInput('code'), true
            )
            ->addField(
                $this->builder->buildInput('prmUrlMask')
            )
            ->addField(
                $this
                    ->builder
                    ->buildTextEditor('body')
                    ->setMini(true)
                    ->setWidthPercent(100)
            )
            ->addFilter(
                $this
                    ->builder
                    ->buildInput('search_by_code')
            )
            ->addFilter(
                $this
                    ->builder
                    ->buildInput('search_by_urlMask')
            )
            ->addFilter(
                $this
                    ->builder
                    ->buildInput('search_by_title')
            );

        $this->tableFactory->prepareAdminTableForDomain($table);

        return $table->render();
    }

    /**
     * @param PromoBlockEntityInterface $pormoblock
     * @return string
     */
    public function formatAction(PromoBlockEntityInterface $pormoblock): string
    {
        return $this->builder->buildActionMenuAdmin([], $pormoblock->getId())->render();
    }


    /**
     * @param PromoBlockEntityInterface|Promoblock $pormoblock
     * @return string
     */
    public function formatUrl(PromoBlockEntityInterface $pormoblock): string
    {
        return $pormoblock->getPrmurlMask();
    }

    /**
     * @param PromoBlockEntityInterface $pormoblock
     * @return string
     */
    public function formatBody(PromoBlockEntityInterface $pormoblock): string
    {
        return trim(
            str_replace(
                array(
                    '\r\n', '\n'
                ),
                '',
                Text::characterLimiter(strip_tags($pormoblock->getBody()), 80)));
    }

}