<?php

namespace Diamond\Helpers;

/**
 * Description of Formatter
 *
 * @author Admin
 */
final class Formatter
{

    /**
     * @param string $txt
     * @param int $len
     * @return string
     */
    public static function formatLongText(string $txt, int $len = 80): string
    {
        return trim(str_replace(array("\r\n", "\n"), '', Text::characterLimiter(strip_tags($txt), $len)));
    }

    /**
     * @param string $txt
     * @param array $colors
     * @param bool $digital
     * @return string
     */
    public static function formatYN(string $txt, array $colors = [],bool $digital = false): string
    {
       if($digital === true){

           $result = (int)$txt === 1 ? 'Да' : 'Нет';
       }
       else{
           $result = $txt === 'Y' ? 'Да' : 'Нет';
       }

        if (isset($colors[$txt])) {
            return sprintf('<div class="label label-table %s">%s</div>', $colors[$txt], $result);
        }

        return $result;
    }
}
