<?php

namespace Diamond\Controllers;

use Core\BaseController;
use Diamond\Application\Content\ContentService;
use Diamond\Application\Content\Exceptions\PageNotFoundException;
use Diamond\Application\System\SystemService;
use Diamond\Factory\PublicPageFactory;
use Exception;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class IndexController extends BaseController
{

    use PageFactoryTrait;

    public function __construct(protected SystemService $systemService,
                                protected Request $request,
                                protected ContentService $contentService)
    {
        $this->pageFactory = new PublicPageFactory($systemService,$contentService,$request);
    }

    public function index()
    {

        try{

            //загружаем страницу
            if (!$page = $this->contentService->getPage($this->request)) {
                throw new PageNotFoundException($this->request->getPathInfo());
            }

            return new Response( $this->pageFactory->renderPage($page));
        }
        catch (Exception $exception){
            return $this->getSystemPageFromException($exception);
        }
    }

}
