<?php

namespace Diamond\Infrastructure\Models\MessageRequest\Map;

use Diamond\Infrastructure\Models\MessageRequest\MessageRequest;
use Diamond\Infrastructure\Models\MessageRequest\MessageRequestQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_message_requests' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class MessageRequestTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.MessageRequest.Map.MessageRequestTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_message_requests';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\MessageRequest\\MessageRequest';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.MessageRequest.MessageRequest';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_message_requests.id';

    /**
     * the column name for the email_to field
     */
    public const COL_EMAIL_TO = '_message_requests.email_to';

    /**
     * the column name for the email_from field
     */
    public const COL_EMAIL_FROM = '_message_requests.email_from';

    /**
     * the column name for the subject field
     */
    public const COL_SUBJECT = '_message_requests.subject';

    /**
     * the column name for the body field
     */
    public const COL_BODY = '_message_requests.body';

    /**
     * the column name for the attachments field
     */
    public const COL_ATTACHMENTS = '_message_requests.attachments';

    /**
     * the column name for the created_at field
     */
    public const COL_CREATED_AT = '_message_requests.created_at';

    /**
     * the column name for the status field
     */
    public const COL_STATUS = '_message_requests.status';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'EmailTo', 'EmailFrom', 'Subject', 'Body', 'Attachments', 'CreatedAt', 'Status', ],
        self::TYPE_CAMELNAME     => ['id', 'emailTo', 'emailFrom', 'subject', 'body', 'attachments', 'createdAt', 'status', ],
        self::TYPE_COLNAME       => [MessageRequestTableMap::COL_ID, MessageRequestTableMap::COL_EMAIL_TO, MessageRequestTableMap::COL_EMAIL_FROM, MessageRequestTableMap::COL_SUBJECT, MessageRequestTableMap::COL_BODY, MessageRequestTableMap::COL_ATTACHMENTS, MessageRequestTableMap::COL_CREATED_AT, MessageRequestTableMap::COL_STATUS, ],
        self::TYPE_FIELDNAME     => ['id', 'email_to', 'email_from', 'subject', 'body', 'attachments', 'created_at', 'status', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'EmailTo' => 1, 'EmailFrom' => 2, 'Subject' => 3, 'Body' => 4, 'Attachments' => 5, 'CreatedAt' => 6, 'Status' => 7, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'emailTo' => 1, 'emailFrom' => 2, 'subject' => 3, 'body' => 4, 'attachments' => 5, 'createdAt' => 6, 'status' => 7, ],
        self::TYPE_COLNAME       => [MessageRequestTableMap::COL_ID => 0, MessageRequestTableMap::COL_EMAIL_TO => 1, MessageRequestTableMap::COL_EMAIL_FROM => 2, MessageRequestTableMap::COL_SUBJECT => 3, MessageRequestTableMap::COL_BODY => 4, MessageRequestTableMap::COL_ATTACHMENTS => 5, MessageRequestTableMap::COL_CREATED_AT => 6, MessageRequestTableMap::COL_STATUS => 7, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'email_to' => 1, 'email_from' => 2, 'subject' => 3, 'body' => 4, 'attachments' => 5, 'created_at' => 6, 'status' => 7, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'MessageRequest.Id' => 'ID',
        'id' => 'ID',
        'messageRequest.id' => 'ID',
        'MessageRequestTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_message_requests.id' => 'ID',
        'EmailTo' => 'EMAIL_TO',
        'MessageRequest.EmailTo' => 'EMAIL_TO',
        'emailTo' => 'EMAIL_TO',
        'messageRequest.emailTo' => 'EMAIL_TO',
        'MessageRequestTableMap::COL_EMAIL_TO' => 'EMAIL_TO',
        'COL_EMAIL_TO' => 'EMAIL_TO',
        'email_to' => 'EMAIL_TO',
        '_message_requests.email_to' => 'EMAIL_TO',
        'EmailFrom' => 'EMAIL_FROM',
        'MessageRequest.EmailFrom' => 'EMAIL_FROM',
        'emailFrom' => 'EMAIL_FROM',
        'messageRequest.emailFrom' => 'EMAIL_FROM',
        'MessageRequestTableMap::COL_EMAIL_FROM' => 'EMAIL_FROM',
        'COL_EMAIL_FROM' => 'EMAIL_FROM',
        'email_from' => 'EMAIL_FROM',
        '_message_requests.email_from' => 'EMAIL_FROM',
        'Subject' => 'SUBJECT',
        'MessageRequest.Subject' => 'SUBJECT',
        'subject' => 'SUBJECT',
        'messageRequest.subject' => 'SUBJECT',
        'MessageRequestTableMap::COL_SUBJECT' => 'SUBJECT',
        'COL_SUBJECT' => 'SUBJECT',
        '_message_requests.subject' => 'SUBJECT',
        'Body' => 'BODY',
        'MessageRequest.Body' => 'BODY',
        'body' => 'BODY',
        'messageRequest.body' => 'BODY',
        'MessageRequestTableMap::COL_BODY' => 'BODY',
        'COL_BODY' => 'BODY',
        '_message_requests.body' => 'BODY',
        'Attachments' => 'ATTACHMENTS',
        'MessageRequest.Attachments' => 'ATTACHMENTS',
        'attachments' => 'ATTACHMENTS',
        'messageRequest.attachments' => 'ATTACHMENTS',
        'MessageRequestTableMap::COL_ATTACHMENTS' => 'ATTACHMENTS',
        'COL_ATTACHMENTS' => 'ATTACHMENTS',
        '_message_requests.attachments' => 'ATTACHMENTS',
        'CreatedAt' => 'CREATED_AT',
        'MessageRequest.CreatedAt' => 'CREATED_AT',
        'createdAt' => 'CREATED_AT',
        'messageRequest.createdAt' => 'CREATED_AT',
        'MessageRequestTableMap::COL_CREATED_AT' => 'CREATED_AT',
        'COL_CREATED_AT' => 'CREATED_AT',
        'created_at' => 'CREATED_AT',
        '_message_requests.created_at' => 'CREATED_AT',
        'Status' => 'STATUS',
        'MessageRequest.Status' => 'STATUS',
        'status' => 'STATUS',
        'messageRequest.status' => 'STATUS',
        'MessageRequestTableMap::COL_STATUS' => 'STATUS',
        'COL_STATUS' => 'STATUS',
        '_message_requests.status' => 'STATUS',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_message_requests');
        $this->setPhpName('MessageRequest');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\MessageRequest\\MessageRequest');
        $this->setPackage('Diamond.Infrastructure.Models.MessageRequest');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('email_to', 'EmailTo', 'VARCHAR', true, 50, null);
        $this->addColumn('email_from', 'EmailFrom', 'VARCHAR', true, 50, null);
        $this->addColumn('subject', 'Subject', 'VARCHAR', false, 255, null);
        $this->addColumn('body', 'Body', 'LONGVARCHAR', true, null, null);
        $this->addColumn('attachments', 'Attachments', 'LONGVARCHAR', false, null, null);
        $this->addColumn('created_at', 'CreatedAt', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('status', 'Status', 'VARCHAR', false, 50, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? MessageRequestTableMap::CLASS_DEFAULT : MessageRequestTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (MessageRequest object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = MessageRequestTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = MessageRequestTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + MessageRequestTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = MessageRequestTableMap::OM_CLASS;
            /** @var MessageRequest $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            MessageRequestTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = MessageRequestTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = MessageRequestTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var MessageRequest $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                MessageRequestTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(MessageRequestTableMap::COL_ID);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_EMAIL_TO);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_EMAIL_FROM);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_SUBJECT);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_BODY);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_ATTACHMENTS);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_CREATED_AT);
            $criteria->addSelectColumn(MessageRequestTableMap::COL_STATUS);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.email_to');
            $criteria->addSelectColumn($alias . '.email_from');
            $criteria->addSelectColumn($alias . '.subject');
            $criteria->addSelectColumn($alias . '.body');
            $criteria->addSelectColumn($alias . '.attachments');
            $criteria->addSelectColumn($alias . '.created_at');
            $criteria->addSelectColumn($alias . '.status');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_ID);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_EMAIL_TO);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_EMAIL_FROM);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_SUBJECT);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_BODY);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_ATTACHMENTS);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_CREATED_AT);
            $criteria->removeSelectColumn(MessageRequestTableMap::COL_STATUS);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.email_to');
            $criteria->removeSelectColumn($alias . '.email_from');
            $criteria->removeSelectColumn($alias . '.subject');
            $criteria->removeSelectColumn($alias . '.body');
            $criteria->removeSelectColumn($alias . '.attachments');
            $criteria->removeSelectColumn($alias . '.created_at');
            $criteria->removeSelectColumn($alias . '.status');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(MessageRequestTableMap::DATABASE_NAME)->getTable(MessageRequestTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a MessageRequest or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or MessageRequest object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MessageRequestTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\MessageRequest\MessageRequest) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(MessageRequestTableMap::DATABASE_NAME);
            $criteria->add(MessageRequestTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = MessageRequestQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            MessageRequestTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                MessageRequestTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _message_requests table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return MessageRequestQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a MessageRequest or Criteria object.
     *
     * @param mixed $criteria Criteria or MessageRequest object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MessageRequestTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from MessageRequest object
        }

        if ($criteria->containsKey(MessageRequestTableMap::COL_ID) && $criteria->keyContainsValue(MessageRequestTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.MessageRequestTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = MessageRequestQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
