<?php

namespace Diamond\Infrastructure\Models\MailingMessage\Map;

use Diamond\Infrastructure\Models\MailingMessage\MailingMessage;
use Diamond\Infrastructure\Models\MailingMessage\MailingMessageQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_mailing_messages' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class MailingMessageTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.MailingMessage.Map.MailingMessageTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_mailing_messages';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\MailingMessage\\MailingMessage';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.MailingMessage.MailingMessage';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_mailing_messages.id';

    /**
     * the column name for the to_email field
     */
    public const COL_TO_EMAIL = '_mailing_messages.to_email';

    /**
     * the column name for the to_name field
     */
    public const COL_TO_NAME = '_mailing_messages.to_name';

    /**
     * the column name for the from_email field
     */
    public const COL_FROM_EMAIL = '_mailing_messages.from_email';

    /**
     * the column name for the from_name field
     */
    public const COL_FROM_NAME = '_mailing_messages.from_name';

    /**
     * the column name for the mat_id field
     */
    public const COL_MAT_ID = '_mailing_messages.mat_id';

    /**
     * the column name for the sub_id field
     */
    public const COL_SUB_ID = '_mailing_messages.sub_id';

    /**
     * the column name for the mal_test_mail field
     */
    public const COL_MAL_TEST_MAIL = '_mailing_messages.mal_test_mail';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'ToEmail', 'ToName', 'FromEmail', 'FromName', 'MatId', 'SubId', 'MalTestMail', ],
        self::TYPE_CAMELNAME     => ['id', 'toEmail', 'toName', 'fromEmail', 'fromName', 'matId', 'subId', 'malTestMail', ],
        self::TYPE_COLNAME       => [MailingMessageTableMap::COL_ID, MailingMessageTableMap::COL_TO_EMAIL, MailingMessageTableMap::COL_TO_NAME, MailingMessageTableMap::COL_FROM_EMAIL, MailingMessageTableMap::COL_FROM_NAME, MailingMessageTableMap::COL_MAT_ID, MailingMessageTableMap::COL_SUB_ID, MailingMessageTableMap::COL_MAL_TEST_MAIL, ],
        self::TYPE_FIELDNAME     => ['id', 'to_email', 'to_name', 'from_email', 'from_name', 'mat_id', 'sub_id', 'mal_test_mail', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'ToEmail' => 1, 'ToName' => 2, 'FromEmail' => 3, 'FromName' => 4, 'MatId' => 5, 'SubId' => 6, 'MalTestMail' => 7, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'toEmail' => 1, 'toName' => 2, 'fromEmail' => 3, 'fromName' => 4, 'matId' => 5, 'subId' => 6, 'malTestMail' => 7, ],
        self::TYPE_COLNAME       => [MailingMessageTableMap::COL_ID => 0, MailingMessageTableMap::COL_TO_EMAIL => 1, MailingMessageTableMap::COL_TO_NAME => 2, MailingMessageTableMap::COL_FROM_EMAIL => 3, MailingMessageTableMap::COL_FROM_NAME => 4, MailingMessageTableMap::COL_MAT_ID => 5, MailingMessageTableMap::COL_SUB_ID => 6, MailingMessageTableMap::COL_MAL_TEST_MAIL => 7, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'to_email' => 1, 'to_name' => 2, 'from_email' => 3, 'from_name' => 4, 'mat_id' => 5, 'sub_id' => 6, 'mal_test_mail' => 7, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'MailingMessage.Id' => 'ID',
        'id' => 'ID',
        'mailingMessage.id' => 'ID',
        'MailingMessageTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_mailing_messages.id' => 'ID',
        'ToEmail' => 'TO_EMAIL',
        'MailingMessage.ToEmail' => 'TO_EMAIL',
        'toEmail' => 'TO_EMAIL',
        'mailingMessage.toEmail' => 'TO_EMAIL',
        'MailingMessageTableMap::COL_TO_EMAIL' => 'TO_EMAIL',
        'COL_TO_EMAIL' => 'TO_EMAIL',
        'to_email' => 'TO_EMAIL',
        '_mailing_messages.to_email' => 'TO_EMAIL',
        'ToName' => 'TO_NAME',
        'MailingMessage.ToName' => 'TO_NAME',
        'toName' => 'TO_NAME',
        'mailingMessage.toName' => 'TO_NAME',
        'MailingMessageTableMap::COL_TO_NAME' => 'TO_NAME',
        'COL_TO_NAME' => 'TO_NAME',
        'to_name' => 'TO_NAME',
        '_mailing_messages.to_name' => 'TO_NAME',
        'FromEmail' => 'FROM_EMAIL',
        'MailingMessage.FromEmail' => 'FROM_EMAIL',
        'fromEmail' => 'FROM_EMAIL',
        'mailingMessage.fromEmail' => 'FROM_EMAIL',
        'MailingMessageTableMap::COL_FROM_EMAIL' => 'FROM_EMAIL',
        'COL_FROM_EMAIL' => 'FROM_EMAIL',
        'from_email' => 'FROM_EMAIL',
        '_mailing_messages.from_email' => 'FROM_EMAIL',
        'FromName' => 'FROM_NAME',
        'MailingMessage.FromName' => 'FROM_NAME',
        'fromName' => 'FROM_NAME',
        'mailingMessage.fromName' => 'FROM_NAME',
        'MailingMessageTableMap::COL_FROM_NAME' => 'FROM_NAME',
        'COL_FROM_NAME' => 'FROM_NAME',
        'from_name' => 'FROM_NAME',
        '_mailing_messages.from_name' => 'FROM_NAME',
        'MatId' => 'MAT_ID',
        'MailingMessage.MatId' => 'MAT_ID',
        'matId' => 'MAT_ID',
        'mailingMessage.matId' => 'MAT_ID',
        'MailingMessageTableMap::COL_MAT_ID' => 'MAT_ID',
        'COL_MAT_ID' => 'MAT_ID',
        'mat_id' => 'MAT_ID',
        '_mailing_messages.mat_id' => 'MAT_ID',
        'SubId' => 'SUB_ID',
        'MailingMessage.SubId' => 'SUB_ID',
        'subId' => 'SUB_ID',
        'mailingMessage.subId' => 'SUB_ID',
        'MailingMessageTableMap::COL_SUB_ID' => 'SUB_ID',
        'COL_SUB_ID' => 'SUB_ID',
        'sub_id' => 'SUB_ID',
        '_mailing_messages.sub_id' => 'SUB_ID',
        'MalTestMail' => 'MAL_TEST_MAIL',
        'MailingMessage.MalTestMail' => 'MAL_TEST_MAIL',
        'malTestMail' => 'MAL_TEST_MAIL',
        'mailingMessage.malTestMail' => 'MAL_TEST_MAIL',
        'MailingMessageTableMap::COL_MAL_TEST_MAIL' => 'MAL_TEST_MAIL',
        'COL_MAL_TEST_MAIL' => 'MAL_TEST_MAIL',
        'mal_test_mail' => 'MAL_TEST_MAIL',
        '_mailing_messages.mal_test_mail' => 'MAL_TEST_MAIL',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_mailing_messages');
        $this->setPhpName('MailingMessage');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\MailingMessage\\MailingMessage');
        $this->setPackage('Diamond.Infrastructure.Models.MailingMessage');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('to_email', 'ToEmail', 'VARCHAR', false, 255, null);
        $this->addColumn('to_name', 'ToName', 'VARCHAR', false, 255, null);
        $this->addColumn('from_email', 'FromEmail', 'VARCHAR', false, 255, null);
        $this->addColumn('from_name', 'FromName', 'VARCHAR', false, 255, null);
        $this->addForeignKey('mat_id', 'MatId', 'INTEGER', '_mailing_template', 'id', false, null, null);
        $this->addForeignKey('sub_id', 'SubId', 'INTEGER', '_mailing_subscribers', 'id', false, null, null);
        $this->addColumn('mal_test_mail', 'MalTestMail', 'VARCHAR', false, 100, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('MailingSubscriber', '\\Diamond\\Infrastructure\\Models\\MailingSubscriber\\MailingSubscriber', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':sub_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('MailingTemplate', '\\Diamond\\Infrastructure\\Models\\MailingTemplate\\MailingTemplate', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':mat_id',
    1 => ':id',
  ),
), null, null, null, false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? MailingMessageTableMap::CLASS_DEFAULT : MailingMessageTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (MailingMessage object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = MailingMessageTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = MailingMessageTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + MailingMessageTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = MailingMessageTableMap::OM_CLASS;
            /** @var MailingMessage $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            MailingMessageTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = MailingMessageTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = MailingMessageTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var MailingMessage $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                MailingMessageTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(MailingMessageTableMap::COL_ID);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_TO_EMAIL);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_TO_NAME);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_FROM_EMAIL);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_FROM_NAME);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_MAT_ID);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_SUB_ID);
            $criteria->addSelectColumn(MailingMessageTableMap::COL_MAL_TEST_MAIL);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.to_email');
            $criteria->addSelectColumn($alias . '.to_name');
            $criteria->addSelectColumn($alias . '.from_email');
            $criteria->addSelectColumn($alias . '.from_name');
            $criteria->addSelectColumn($alias . '.mat_id');
            $criteria->addSelectColumn($alias . '.sub_id');
            $criteria->addSelectColumn($alias . '.mal_test_mail');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_ID);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_TO_EMAIL);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_TO_NAME);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_FROM_EMAIL);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_FROM_NAME);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_MAT_ID);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_SUB_ID);
            $criteria->removeSelectColumn(MailingMessageTableMap::COL_MAL_TEST_MAIL);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.to_email');
            $criteria->removeSelectColumn($alias . '.to_name');
            $criteria->removeSelectColumn($alias . '.from_email');
            $criteria->removeSelectColumn($alias . '.from_name');
            $criteria->removeSelectColumn($alias . '.mat_id');
            $criteria->removeSelectColumn($alias . '.sub_id');
            $criteria->removeSelectColumn($alias . '.mal_test_mail');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(MailingMessageTableMap::DATABASE_NAME)->getTable(MailingMessageTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a MailingMessage or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or MailingMessage object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\MailingMessage\MailingMessage) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(MailingMessageTableMap::DATABASE_NAME);
            $criteria->add(MailingMessageTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = MailingMessageQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            MailingMessageTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                MailingMessageTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _mailing_messages table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return MailingMessageQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a MailingMessage or Criteria object.
     *
     * @param mixed $criteria Criteria or MailingMessage object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(MailingMessageTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from MailingMessage object
        }

        if ($criteria->containsKey(MailingMessageTableMap::COL_ID) && $criteria->keyContainsValue(MailingMessageTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.MailingMessageTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = MailingMessageQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
