<?php

namespace Diamond\Infrastructure\Models\CasbinRule\Map;

use Diamond\Infrastructure\Models\CasbinRule\CasbinRule;
use Diamond\Infrastructure\Models\CasbinRule\CasbinRuleQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the '_casbin_rule' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class CasbinRuleTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Diamond.Infrastructure.Models.CasbinRule.Map.CasbinRuleTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = '_casbin_rule';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Diamond\\Infrastructure\\Models\\CasbinRule\\CasbinRule';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Diamond.Infrastructure.Models.CasbinRule.CasbinRule';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 8;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 8;

    /**
     * the column name for the id field
     */
    public const COL_ID = '_casbin_rule.id';

    /**
     * the column name for the ptype field
     */
    public const COL_PTYPE = '_casbin_rule.ptype';

    /**
     * the column name for the v0 field
     */
    public const COL_V0 = '_casbin_rule.v0';

    /**
     * the column name for the v1 field
     */
    public const COL_V1 = '_casbin_rule.v1';

    /**
     * the column name for the v2 field
     */
    public const COL_V2 = '_casbin_rule.v2';

    /**
     * the column name for the v3 field
     */
    public const COL_V3 = '_casbin_rule.v3';

    /**
     * the column name for the v4 field
     */
    public const COL_V4 = '_casbin_rule.v4';

    /**
     * the column name for the v5 field
     */
    public const COL_V5 = '_casbin_rule.v5';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Ptype', 'V0', 'V1', 'V2', 'V3', 'V4', 'V5', ],
        self::TYPE_CAMELNAME     => ['id', 'ptype', 'v0', 'v1', 'v2', 'v3', 'v4', 'v5', ],
        self::TYPE_COLNAME       => [CasbinRuleTableMap::COL_ID, CasbinRuleTableMap::COL_PTYPE, CasbinRuleTableMap::COL_V0, CasbinRuleTableMap::COL_V1, CasbinRuleTableMap::COL_V2, CasbinRuleTableMap::COL_V3, CasbinRuleTableMap::COL_V4, CasbinRuleTableMap::COL_V5, ],
        self::TYPE_FIELDNAME     => ['id', 'ptype', 'v0', 'v1', 'v2', 'v3', 'v4', 'v5', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Ptype' => 1, 'V0' => 2, 'V1' => 3, 'V2' => 4, 'V3' => 5, 'V4' => 6, 'V5' => 7, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'ptype' => 1, 'v0' => 2, 'v1' => 3, 'v2' => 4, 'v3' => 5, 'v4' => 6, 'v5' => 7, ],
        self::TYPE_COLNAME       => [CasbinRuleTableMap::COL_ID => 0, CasbinRuleTableMap::COL_PTYPE => 1, CasbinRuleTableMap::COL_V0 => 2, CasbinRuleTableMap::COL_V1 => 3, CasbinRuleTableMap::COL_V2 => 4, CasbinRuleTableMap::COL_V3 => 5, CasbinRuleTableMap::COL_V4 => 6, CasbinRuleTableMap::COL_V5 => 7, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'ptype' => 1, 'v0' => 2, 'v1' => 3, 'v2' => 4, 'v3' => 5, 'v4' => 6, 'v5' => 7, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'CasbinRule.Id' => 'ID',
        'id' => 'ID',
        'casbinRule.id' => 'ID',
        'CasbinRuleTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        '_casbin_rule.id' => 'ID',
        'Ptype' => 'PTYPE',
        'CasbinRule.Ptype' => 'PTYPE',
        'ptype' => 'PTYPE',
        'casbinRule.ptype' => 'PTYPE',
        'CasbinRuleTableMap::COL_PTYPE' => 'PTYPE',
        'COL_PTYPE' => 'PTYPE',
        '_casbin_rule.ptype' => 'PTYPE',
        'V0' => 'V0',
        'CasbinRule.V0' => 'V0',
        'v0' => 'V0',
        'casbinRule.v0' => 'V0',
        'CasbinRuleTableMap::COL_V0' => 'V0',
        'COL_V0' => 'V0',
        '_casbin_rule.v0' => 'V0',
        'V1' => 'V1',
        'CasbinRule.V1' => 'V1',
        'v1' => 'V1',
        'casbinRule.v1' => 'V1',
        'CasbinRuleTableMap::COL_V1' => 'V1',
        'COL_V1' => 'V1',
        '_casbin_rule.v1' => 'V1',
        'V2' => 'V2',
        'CasbinRule.V2' => 'V2',
        'v2' => 'V2',
        'casbinRule.v2' => 'V2',
        'CasbinRuleTableMap::COL_V2' => 'V2',
        'COL_V2' => 'V2',
        '_casbin_rule.v2' => 'V2',
        'V3' => 'V3',
        'CasbinRule.V3' => 'V3',
        'v3' => 'V3',
        'casbinRule.v3' => 'V3',
        'CasbinRuleTableMap::COL_V3' => 'V3',
        'COL_V3' => 'V3',
        '_casbin_rule.v3' => 'V3',
        'V4' => 'V4',
        'CasbinRule.V4' => 'V4',
        'v4' => 'V4',
        'casbinRule.v4' => 'V4',
        'CasbinRuleTableMap::COL_V4' => 'V4',
        'COL_V4' => 'V4',
        '_casbin_rule.v4' => 'V4',
        'V5' => 'V5',
        'CasbinRule.V5' => 'V5',
        'v5' => 'V5',
        'casbinRule.v5' => 'V5',
        'CasbinRuleTableMap::COL_V5' => 'V5',
        'COL_V5' => 'V5',
        '_casbin_rule.v5' => 'V5',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('_casbin_rule');
        $this->setPhpName('CasbinRule');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Diamond\\Infrastructure\\Models\\CasbinRule\\CasbinRule');
        $this->setPackage('Diamond.Infrastructure.Models.CasbinRule');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('ptype', 'Ptype', 'VARCHAR', true, 255, null);
        $this->addColumn('v0', 'V0', 'VARCHAR', true, 255, null);
        $this->addColumn('v1', 'V1', 'VARCHAR', true, 255, null);
        $this->addColumn('v2', 'V2', 'VARCHAR', true, 255, null);
        $this->addColumn('v3', 'V3', 'VARCHAR', true, 255, null);
        $this->addColumn('v4', 'V4', 'VARCHAR', true, 255, null);
        $this->addColumn('v5', 'V5', 'VARCHAR', true, 255, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? CasbinRuleTableMap::CLASS_DEFAULT : CasbinRuleTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (CasbinRule object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = CasbinRuleTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = CasbinRuleTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + CasbinRuleTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CasbinRuleTableMap::OM_CLASS;
            /** @var CasbinRule $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            CasbinRuleTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = CasbinRuleTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = CasbinRuleTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var CasbinRule $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CasbinRuleTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_ID);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_PTYPE);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_V0);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_V1);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_V2);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_V3);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_V4);
            $criteria->addSelectColumn(CasbinRuleTableMap::COL_V5);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.ptype');
            $criteria->addSelectColumn($alias . '.v0');
            $criteria->addSelectColumn($alias . '.v1');
            $criteria->addSelectColumn($alias . '.v2');
            $criteria->addSelectColumn($alias . '.v3');
            $criteria->addSelectColumn($alias . '.v4');
            $criteria->addSelectColumn($alias . '.v5');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_ID);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_PTYPE);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_V0);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_V1);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_V2);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_V3);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_V4);
            $criteria->removeSelectColumn(CasbinRuleTableMap::COL_V5);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.ptype');
            $criteria->removeSelectColumn($alias . '.v0');
            $criteria->removeSelectColumn($alias . '.v1');
            $criteria->removeSelectColumn($alias . '.v2');
            $criteria->removeSelectColumn($alias . '.v3');
            $criteria->removeSelectColumn($alias . '.v4');
            $criteria->removeSelectColumn($alias . '.v5');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(CasbinRuleTableMap::DATABASE_NAME)->getTable(CasbinRuleTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a CasbinRule or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or CasbinRule object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CasbinRuleTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Diamond\Infrastructure\Models\CasbinRule\CasbinRule) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CasbinRuleTableMap::DATABASE_NAME);
            $criteria->add(CasbinRuleTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = CasbinRuleQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            CasbinRuleTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                CasbinRuleTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the _casbin_rule table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return CasbinRuleQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a CasbinRule or Criteria object.
     *
     * @param mixed $criteria Criteria or CasbinRule object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CasbinRuleTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from CasbinRule object
        }

        if ($criteria->containsKey(CasbinRuleTableMap::COL_ID) && $criteria->keyContainsValue(CasbinRuleTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.CasbinRuleTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = CasbinRuleQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
