<?php

namespace Diamond\Infrastructure\Models\AccessRule\Base;

use \Exception;
use \PDO;
use Diamond\Infrastructure\Models\AccessRule\AccessRulesArchive as ChildAccessRulesArchive;
use Diamond\Infrastructure\Models\AccessRule\AccessRulesArchiveQuery as ChildAccessRulesArchiveQuery;
use Diamond\Infrastructure\Models\AccessRule\Map\AccessRulesArchiveTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the '_access_rules_archive' table.
 *
 *
 *
 * @method     ChildAccessRulesArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildAccessRulesArchiveQuery orderByObject($order = Criteria::ASC) Order by the object column
 * @method     ChildAccessRulesArchiveQuery orderByObjectName($order = Criteria::ASC) Order by the object_name column
 * @method     ChildAccessRulesArchiveQuery orderByRead($order = Criteria::ASC) Order by the read column
 * @method     ChildAccessRulesArchiveQuery orderByCreate($order = Criteria::ASC) Order by the create column
 * @method     ChildAccessRulesArchiveQuery orderByUpdate($order = Criteria::ASC) Order by the update column
 * @method     ChildAccessRulesArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildAccessRulesArchiveQuery groupById() Group by the id column
 * @method     ChildAccessRulesArchiveQuery groupByObject() Group by the object column
 * @method     ChildAccessRulesArchiveQuery groupByObjectName() Group by the object_name column
 * @method     ChildAccessRulesArchiveQuery groupByRead() Group by the read column
 * @method     ChildAccessRulesArchiveQuery groupByCreate() Group by the create column
 * @method     ChildAccessRulesArchiveQuery groupByUpdate() Group by the update column
 * @method     ChildAccessRulesArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildAccessRulesArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildAccessRulesArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildAccessRulesArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildAccessRulesArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildAccessRulesArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildAccessRulesArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildAccessRulesArchive|null findOne(?ConnectionInterface $con = null) Return the first ChildAccessRulesArchive matching the query
 * @method     ChildAccessRulesArchive findOneOrCreate(?ConnectionInterface $con = null) Return the first ChildAccessRulesArchive matching the query, or a new ChildAccessRulesArchive object populated from the query conditions when no match is found
 *
 * @method     ChildAccessRulesArchive|null findOneById(int $id) Return the first ChildAccessRulesArchive filtered by the id column
 * @method     ChildAccessRulesArchive|null findOneByObject(string $object) Return the first ChildAccessRulesArchive filtered by the object column
 * @method     ChildAccessRulesArchive|null findOneByObjectName(string $object_name) Return the first ChildAccessRulesArchive filtered by the object_name column
 * @method     ChildAccessRulesArchive|null findOneByRead(string $read) Return the first ChildAccessRulesArchive filtered by the read column
 * @method     ChildAccessRulesArchive|null findOneByCreate(string $create) Return the first ChildAccessRulesArchive filtered by the create column
 * @method     ChildAccessRulesArchive|null findOneByUpdate(string $update) Return the first ChildAccessRulesArchive filtered by the update column
 * @method     ChildAccessRulesArchive|null findOneByArchivedAt(string $archived_at) Return the first ChildAccessRulesArchive filtered by the archived_at column *

 * @method     ChildAccessRulesArchive requirePk($key, ?ConnectionInterface $con = null) Return the ChildAccessRulesArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOne(?ConnectionInterface $con = null) Return the first ChildAccessRulesArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildAccessRulesArchive requireOneById(int $id) Return the first ChildAccessRulesArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOneByObject(string $object) Return the first ChildAccessRulesArchive filtered by the object column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOneByObjectName(string $object_name) Return the first ChildAccessRulesArchive filtered by the object_name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOneByRead(string $read) Return the first ChildAccessRulesArchive filtered by the read column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOneByCreate(string $create) Return the first ChildAccessRulesArchive filtered by the create column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOneByUpdate(string $update) Return the first ChildAccessRulesArchive filtered by the update column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildAccessRulesArchive requireOneByArchivedAt(string $archived_at) Return the first ChildAccessRulesArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildAccessRulesArchive[]|Collection find(?ConnectionInterface $con = null) Return ChildAccessRulesArchive objects based on current ModelCriteria
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> find(?ConnectionInterface $con = null) Return ChildAccessRulesArchive objects based on current ModelCriteria
 * @method     ChildAccessRulesArchive[]|Collection findById(int $id) Return ChildAccessRulesArchive objects filtered by the id column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findById(int $id) Return ChildAccessRulesArchive objects filtered by the id column
 * @method     ChildAccessRulesArchive[]|Collection findByObject(string $object) Return ChildAccessRulesArchive objects filtered by the object column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findByObject(string $object) Return ChildAccessRulesArchive objects filtered by the object column
 * @method     ChildAccessRulesArchive[]|Collection findByObjectName(string $object_name) Return ChildAccessRulesArchive objects filtered by the object_name column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findByObjectName(string $object_name) Return ChildAccessRulesArchive objects filtered by the object_name column
 * @method     ChildAccessRulesArchive[]|Collection findByRead(string $read) Return ChildAccessRulesArchive objects filtered by the read column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findByRead(string $read) Return ChildAccessRulesArchive objects filtered by the read column
 * @method     ChildAccessRulesArchive[]|Collection findByCreate(string $create) Return ChildAccessRulesArchive objects filtered by the create column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findByCreate(string $create) Return ChildAccessRulesArchive objects filtered by the create column
 * @method     ChildAccessRulesArchive[]|Collection findByUpdate(string $update) Return ChildAccessRulesArchive objects filtered by the update column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findByUpdate(string $update) Return ChildAccessRulesArchive objects filtered by the update column
 * @method     ChildAccessRulesArchive[]|Collection findByArchivedAt(string $archived_at) Return ChildAccessRulesArchive objects filtered by the archived_at column
 * @psalm-method Collection&\Traversable<ChildAccessRulesArchive> findByArchivedAt(string $archived_at) Return ChildAccessRulesArchive objects filtered by the archived_at column
 * @method     ChildAccessRulesArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 * @psalm-method \Propel\Runtime\Util\PropelModelPager&\Traversable<ChildAccessRulesArchive> paginate($page = 1, $maxPerPage = 10, ?ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class AccessRulesArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Diamond\Infrastructure\Models\AccessRule\Base\AccessRulesArchiveQuery object.
     *
     * @param string $dbName The database name
     * @param string $modelName The phpName of a model, e.g. 'Book'
     * @param string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Diamond\\Infrastructure\\Models\\AccessRule\\AccessRulesArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildAccessRulesArchiveQuery object.
     *
     * @param string $modelAlias The alias of a model in the query
     * @param Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildAccessRulesArchiveQuery
     */
    public static function create(?string $modelAlias = null, ?Criteria $criteria = null): Criteria
    {
        if ($criteria instanceof ChildAccessRulesArchiveQuery) {
            return $criteria;
        }
        $query = new ChildAccessRulesArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildAccessRulesArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ?ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(AccessRulesArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = AccessRulesArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildAccessRulesArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `object`, `object_name`, `read`, `create`, `update`, `archived_at` FROM `_access_rules_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildAccessRulesArchive $obj */
            $obj = new ChildAccessRulesArchive();
            $obj->hydrate($row);
            AccessRulesArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con A connection object
     *
     * @return ChildAccessRulesArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param array $keys Primary keys to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return Collection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param mixed $key Primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ID, $key, Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param array|int $keys The list of primary key to use for the query
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ID, $keys, Criteria::IN);

        return $this;
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterById($id = null, ?string $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ID, $id, $comparison);

        return $this;
    }

    /**
     * Filter the query on the object column
     *
     * Example usage:
     * <code>
     * $query->filterByObject('fooValue');   // WHERE object = 'fooValue'
     * $query->filterByObject('%fooValue%', Criteria::LIKE); // WHERE object LIKE '%fooValue%'
     * $query->filterByObject(['foo', 'bar']); // WHERE object IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $object The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByObject($object = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($object)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_OBJECT, $object, $comparison);

        return $this;
    }

    /**
     * Filter the query on the object_name column
     *
     * Example usage:
     * <code>
     * $query->filterByObjectName('fooValue');   // WHERE object_name = 'fooValue'
     * $query->filterByObjectName('%fooValue%', Criteria::LIKE); // WHERE object_name LIKE '%fooValue%'
     * $query->filterByObjectName(['foo', 'bar']); // WHERE object_name IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $objectName The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByObjectName($objectName = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($objectName)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_OBJECT_NAME, $objectName, $comparison);

        return $this;
    }

    /**
     * Filter the query on the read column
     *
     * Example usage:
     * <code>
     * $query->filterByRead('fooValue');   // WHERE read = 'fooValue'
     * $query->filterByRead('%fooValue%', Criteria::LIKE); // WHERE read LIKE '%fooValue%'
     * $query->filterByRead(['foo', 'bar']); // WHERE read IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $read The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByRead($read = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($read)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_READ, $read, $comparison);

        return $this;
    }

    /**
     * Filter the query on the create column
     *
     * Example usage:
     * <code>
     * $query->filterByCreate('fooValue');   // WHERE create = 'fooValue'
     * $query->filterByCreate('%fooValue%', Criteria::LIKE); // WHERE create LIKE '%fooValue%'
     * $query->filterByCreate(['foo', 'bar']); // WHERE create IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $create The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByCreate($create = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($create)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_CREATE, $create, $comparison);

        return $this;
    }

    /**
     * Filter the query on the update column
     *
     * Example usage:
     * <code>
     * $query->filterByUpdate('fooValue');   // WHERE update = 'fooValue'
     * $query->filterByUpdate('%fooValue%', Criteria::LIKE); // WHERE update LIKE '%fooValue%'
     * $query->filterByUpdate(['foo', 'bar']); // WHERE update IN ('foo', 'bar')
     * </code>
     *
     * @param string|string[] $update The value to use as filter.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByUpdate($update = null, ?string $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($update)) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_UPDATE, $update, $comparison);

        return $this;
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param string|null $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, ?string $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);

        return $this;
    }

    /**
     * Exclude object from result
     *
     * @param ChildAccessRulesArchive $accessRulesArchive Object to remove from the list of results
     *
     * @return $this The current query, for fluid interface
     */
    public function prune($accessRulesArchive = null)
    {
        if ($accessRulesArchive) {
            $this->addUsingAlias(AccessRulesArchiveTableMap::COL_ID, $accessRulesArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the _access_rules_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(AccessRulesArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            AccessRulesArchiveTableMap::clearInstancePool();
            AccessRulesArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(?ConnectionInterface $con = null): int
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(AccessRulesArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(AccessRulesArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            AccessRulesArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            AccessRulesArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

}
