<?php declare(strict_types=1);

namespace Diamond\Infrastructure\Cache;

class StaticCache
{
    public const CURRENT_CLIENT = 'current-client-';
    public const CLIENT_STAT_DATA = 'client-data-';
    public const CLIENT_SHEETS = 'client-sheets-';
    public const CURRENCY_RATES = 'currency-rates-';
    public const ASSORTMENT_TYPE = 'assortment-type-';
    public const ASSORTMENT_COUNT_POS = 'assortment-';
    public const REPORT_COUNT = 'report-count-';
    public const CLIENT_AUTH_DATA = 'client-auth-';

    protected array $caches = [];

    public function getValue(mixed $value): mixed
    {
        return $this->caches[$value]??null;
    }

    public function setValue(mixed $key, mixed $value): StaticCache
    {
        $this->caches[$key] = $value;
        return $this;
    }


}