<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 26.08.2020
 * Time: 14:51
 */

namespace Diamond\Domain\Template;


use Core\Repository\DropDownInterface;
use Diamond\Domain\Template\Contracts\TemplateEntityInterface;
use Repo\Concrete\AbstractCollection;

class TemplateCollection extends AbstractCollection implements DropDownInterface
{
    protected function getEntityClass(): string
    {
        return TemplateEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity) {
            $ar[$entity->getCode()] = $entity->getDescription();
        }
        return $ar;
    }


}