<?php

namespace Diamond\Application\Mailing;

use Diamond\Config\Mail;
use Nette\Mail\FallbackMailer;

class MailingFactory
{


    public function __construct(private Mail $mail)
    {
    }

    public function buildFallbackMailer(): FallbackMailer
    {
        $conf = $this->mail;

        switch ($conf->getsmtp_email()) {
            case 'smtp':

                $data = [
                    'host' => $conf->getSmtp_host(),
                    'username' => $conf->getsmtp_user(),
                    'password' => $conf->getsmtp_pass(),
                    'secure' => $conf->getsmtp_ssl() === 'Y' ? 'ssl' : '',
                    'timeout' => $conf->getsmtp_timeout()
                ];
                if ($conf->getsmtp_port() > 0) {
                    $data['port'] = $conf->getsmtp_port();
                }

                $driver = new \Nette\Mail\SmtpMailer($data);

                break;

            default:
                $driver = new \Nette\Mail\SendmailMailer();
                break;
        }
        return new \Nette\Mail\FallbackMailer([
            $driver
        ]);
    }

}