<?php


namespace Diamond\Application\GuestBook\Dto;


final class CommentRequest
{
    /**
     * @var string
     */
    protected $name;
    /**
     * @var string
     */
    protected $email;
    /**
     * @var string
     */
    protected $comment;
    /**
     * @var int
     */
    protected $bookId;
    /**
     * @var bool
     */
    protected $published = false;
    /**
     * @var int
     */
    protected $rank = 0;
    /**
     * @var int
     */
    protected $objectId = 0;

    public function __construct(string $name,string $email,string $comment,int $bookId)
    {
        $this
            ->setName($name)
            ->setEmail($email)
            ->setComment($comment)
            ->setBookId($bookId)
        ;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return CommentRequest
     */
    public function setName(string $name): CommentRequest
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return CommentRequest
     */
    public function setEmail(string $email): CommentRequest
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getComment(): string
    {
        return $this->comment;
    }

    /**
     * @param string $comment
     * @return CommentRequest
     */
    public function setComment(string $comment): CommentRequest
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return int
     */
    public function getBookId(): int
    {
        return $this->bookId;
    }

    /**
     * @param int $bookId
     * @return CommentRequest
     */
    public function setBookId(int $bookId): CommentRequest
    {
        $this->bookId = $bookId;
        return $this;
    }

    /**
     * @return bool
     */
    public function getPublished(): bool
    {
        return $this->published;
    }

    /**
     * @param bool $published
     * @return CommentRequest
     */
    public function setPublished(bool $published): CommentRequest
    {
        $this->published = $published;
        return $this;
    }

    /**
     * @return int
     */
    public function getRank(): int
    {
        return $this->rank;
    }

    /**
     * @param int $rank
     * @return CommentRequest
     */
    public function setRank(int $rank): CommentRequest
    {
        $this->rank = $rank;
        return $this;
    }

    /**
     * @return int
     */
    public function getObjectId(): int
    {
        return $this->objectId;
    }

    /**
     * @param int $objectId
     * @return CommentRequest
     */
    public function setObjectId(int $objectId): CommentRequest
    {
        $this->objectId = $objectId;
        return $this;
    }

}