<?php
namespace Diamond;

use Core\Application\Loader;
use Diamond\Application\Mailing\RecipientsHandlerInterface;
use Diamond\Repositories\User\UserCriteria;
use Diamond\Repositories\User\UserRepository;

class UserRecipients implements RecipientsHandlerInterface
{

    public function getName(): string
    {
        return 'Система / Все пользователи';
    }

    public function getMails(): array
    {
        $di = Loader::getInstance()->load('DI');
        /** @var UserRepository $userRepository */
        $userRepository = $di->get(UserRepository::class);

        $userCollection = $userRepository->findByCriteria(UserCriteria::create());

        $emails = [];

        foreach ($userCollection as $user){
            $emails[] = $user->getEmail();
        }

        return $emails;
    }

}