<?php declare(strict_types=1);

namespace Diamond\Presentation\Modules\WidgetDashBoardInfo;

use Core\Concrete\UserAuthAwareTrait;
use Core\Contracts\UserAuthAwareInterface;
use Core\ModuleController;

/**
* Description of WidgetDashBoardInfo
*
* @author Diamond Code Generator
*/
class WidgetDashBoardInfo extends ModuleController implements UserAuthAwareInterface
{
    use UserAuthAwareTrait;

    public function process(): string
    {
        $messages = [];
        
        if (getenv('MODE') === 'dev') {
            $messages [] = 'Включен режим разработки, на рабочем сайте не рекомендуется его использование';
        }
        
        return $this->render([
            'messages' => $messages
        ]);
    }
}               