<?php

namespace Diamond\Modules\TopMailing;

use Diamond\Application\Mailing\MailingService;

/**
 * Description of TopMailing
 *
 * @author Diamond Code Generator
 */
class TopMailing extends \Core\ModuleController
{

    protected $mailing;
    protected $mailingService;

    /**
     * TopMailing constructor.
     * @param MailingService $mailingService
     */
    public function __construct(MailingService $mailingService)
    {
        $this->mailingService = $mailingService;
    }

    /**
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     * @throws \ReflectionException
     * @throws \Repo\Concrete\Exceptions\Collection
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        $mailings = $this->mailingService->getActiveMailing();

        $items = [];

        /**
         * @var \Diamond\Infrastructure\Models\Mailing\Mailing $item
         */
        foreach ($mailings as $item) {

            if(!$data = $item->getProgressData()){
                continue;
            }

            $items[] = [
                'id' => $item->getId(),
                'name' => $item->getMailingTemplate()->getName(),
                'progress' => $data->getProgress(),
                'subscribers' => $item->getMailingSubscriber()->getTitle(),
                'complete' => $data->getSending(),
                'views' => $data->getViews(),
                'all' => $data->getCount()
            ];
        }

        return $this->render([
            'items' => $items
        ]);
    }
}