<?php

namespace Diamond\Modules\FileManager;

use Core\ModuleController;
use Diamond\Application\User\UserService;

/**
 * Description of FileManager
 *
 * @author Diamond Code Generator
 */
class FileManager extends ModuleController
{
    protected $authService;

    public function __construct(UserService $authService)
    {
        $this->authService = $authService;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     *
     */
    public function process(): string
    {
        $user = $this->authService->getAuthUser();

        return $this->render([
            'key' => md5(getenv('ENCRYPTION_KEY') . getenv('BASE_URL') . $user->getEmail() )
        ]);
    }
}               